/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.RawServices;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class AVMRemoveAllSrcWebappsHandler
extends JBPMSpringActionHandler {
    static final long serialVersionUID = 3004374776252613278L;
    private static Log logger = LogFactory.getLog(AVMRemoveAllSrcWebappsHandler.class);

    protected void initialiseHandler(BeanFactory factory) {
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        boolean isSubmitDirectWorkflowSandbox;
        String workflowName = executionContext.getProcessDefinition().getName();
        boolean bl = isSubmitDirectWorkflowSandbox = workflowName != null && workflowName.equals("wcmwf:submitdirect");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AVMRemoveAllSrcWebappsHandler.execute: " + workflowName));
        }
        if (!isSubmitDirectWorkflowSandbox) {
            NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
            Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
            Integer version = (Integer)pkgPath.getFirst();
            String www_dir = (String)pkgPath.getSecond();
            String appbase_dir = www_dir + "/" + "avm_webapps";
            ApplicationContext springContext = RawServices.Instance().getContext();
            VirtServerRegistry vServerRegistry = (VirtServerRegistry)springContext.getBean("VirtServerRegistry");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending JMX message to shut down workflow webapps: [" + version + ", " + appbase_dir + "]"));
            }
            vServerRegistry.removeAllWebapps(version.intValue(), appbase_dir, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sent JMX message to shut down workflow webapps: [" + version + ", " + appbase_dir + "]"));
            }
        }
    }
}

