/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMCopyIn
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-r", 0, "-v", 0};
    private static String USAGE = "usage: [-r] [-v] sourcepath nodepath";
    private boolean fVerbose;

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        AVMNodeDescriptor desc;
        this.fVerbose = flags.containsKey("-v");
        if (flags.containsKey("-r")) {
            this.recursiveCopy(args.get(0), args.get(1));
            return;
        }
        File file = new File(args.get(0));
        if (!file.isFile()) {
            System.err.println(args.get(0) + " not found, or not a file.");
            this.fContext.close();
            System.exit(1);
        }
        if ((desc = this.fAVMRemote.lookup(-1, args.get(1))) == null) {
            try {
                String[] pathBase = this.splitPath(args.get(1));
                if (pathBase.length == 1) {
                    System.err.println(args.get(1) + " is a root path.");
                    this.fContext.close();
                    System.exit(1);
                }
                if (this.fVerbose) {
                    System.out.println(file.getName() + " -> " + pathBase[0]);
                }
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fAVMRemote.createFile(pathBase[0], pathBase[1]);
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        } else {
            if (!desc.isDirectory()) {
                System.err.println("Target must be a directory.");
                this.fContext.close();
                System.exit(1);
            }
            try {
                if (this.fVerbose) {
                    System.out.println(file.getName() + " -> " + args.get(1));
                }
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fAVMRemote.createFile(args.get(1), file.getName());
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    private void recursiveCopy(String sourcePath, String dest) {
        File file = new File(sourcePath);
        if (this.fVerbose) {
            System.out.println(sourcePath + " -> " + dest);
        }
        if (file.isDirectory()) {
            String[] names;
            this.fAVMRemote.createDirectory(dest, file.getName());
            String newDest = dest + '/' + file.getName();
            for (String name : names = file.list()) {
                this.recursiveCopy(sourcePath + File.separatorChar + name, newDest);
            }
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                OutputStream out = this.fAVMRemote.createFile(dest, file.getName());
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        AVMCopyIn me = new AVMCopyIn();
        me.exec(args, flagDefs, 2, USAGE);
    }
}

