/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoCopyOut
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-r", 0, "-v", 0};
    private static String USAGE = "usage: RepoCopyOut [-r] [-v] repopath fspath";
    private boolean fVerbose;

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        File dest;
        this.fVerbose = flags.containsKey("-v");
        String[] pathBase = this.splitPath(args.get(0));
        if (pathBase.length != 2) {
            System.err.println("Cannot copy out root.");
            this.fContext.close();
            System.exit(1);
        }
        String srcPath = args.get(0);
        while (srcPath.startsWith("/")) {
            srcPath = srcPath.substring(1);
        }
        NodeRef root = this.fRepoRemote.getRoot();
        Pair<NodeRef, Boolean> src = this.fRepoRemote.lookup(root, srcPath);
        if (src == null) {
            System.err.println(srcPath + "Not Found.");
            this.fContext.close();
            System.exit(1);
        }
        if (flags.containsKey("-r")) {
            this.recursiveCopy(src, pathBase[1], args.get(1));
            return;
        }
        if (((Boolean)src.getSecond()).booleanValue()) {
            System.err.println(srcPath + " is not a file.");
            this.fContext.close();
            System.exit(1);
        }
        if ((dest = new File(args.get(1))).exists()) {
            if (!dest.isDirectory()) {
                System.err.println("Destination must be a directory.");
                this.fContext.close();
                System.exit(1);
            }
            try {
                InputStream in = this.fRepoRemote.readFile((NodeRef)src.getFirst());
                FileOutputStream out = new FileOutputStream(args.get(1) + File.separator + pathBase[1]);
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        } else {
            try {
                InputStream in = this.fRepoRemote.readFile((NodeRef)src.getFirst());
                FileOutputStream out = new FileOutputStream(args.get(1));
                this.copyStream(in, out);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.fContext.close();
                System.exit(1);
            }
        }
    }

    private void recursiveCopy(Pair<NodeRef, Boolean> src, String name, String dst) {
        String newDst = dst + File.separator + name;
        if (this.fVerbose) {
            System.out.println(name + " -> " + dst);
        }
        if (((Boolean)src.getSecond()).booleanValue()) {
            File destFile = new File(newDst);
            destFile.mkdir();
            Map<String, Pair<NodeRef, Boolean>> listing = this.fRepoRemote.getListing((NodeRef)src.getFirst());
            for (Map.Entry<String, Pair<NodeRef, Boolean>> entry : listing.entrySet()) {
                this.recursiveCopy(entry.getValue(), entry.getKey(), newDst);
            }
            return;
        }
        try {
            InputStream in = this.fRepoRemote.readFile((NodeRef)src.getFirst());
            FileOutputStream out = new FileOutputStream(newDst);
            this.copyStream(in, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fContext.close();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        RepoCopyOut me = new RepoCopyOut();
        me.exec(args, flagDefs, 2, USAGE);
    }
}

