/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.clt;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.clt.CltBase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoLs
extends CltBase {
    private static Object[] flagDefs = new Object[]{"-R", 0};
    private static String USAGE = "usage: RepoLs path";

    @Override
    protected void run(Map<String, List<String>> flags, List<String> args) {
        NodeRef root = this.fRepoRemote.getRoot();
        NodeRef dir = null;
        String path = args.get(0);
        if (path.equals("/")) {
            dir = root;
        } else {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            Pair<NodeRef, Boolean> info = this.fRepoRemote.lookup(root, path);
            if (info == null) {
                System.err.println(path + " does not exist");
                this.fContext.close();
                System.exit(1);
            }
            dir = (NodeRef)info.getFirst();
        }
        if (flags.containsKey("-R")) {
            this.recursiveList(dir, 0);
            return;
        }
        Map<String, Pair<NodeRef, Boolean>> listing = this.fRepoRemote.getListing(dir);
        for (String name : listing.keySet()) {
            System.out.println(name + "\t" + listing.get(name));
        }
    }

    private void recursiveList(NodeRef dir, int indent) {
        Map<String, Pair<NodeRef, Boolean>> listing = this.fRepoRemote.getListing(dir);
        for (Map.Entry<String, Pair<NodeRef, Boolean>> entry : listing.entrySet()) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(' ');
            }
            System.out.println(entry.getKey() + '\t' + entry.getValue());
            if (!((Boolean)entry.getValue().getSecond()).booleanValue()) continue;
            this.recursiveList((NodeRef)entry.getValue().getFirst(), indent + 2);
        }
    }

    public static void main(String[] args) {
        RepoLs me = new RepoLs();
        me.exec(args, flagDefs, 1, USAGE);
    }
}

