/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.VersionableAspect;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutCheckInServiceImpl
implements CheckOutCheckInService {
    private static final String MSG_ERR_BAD_COPY = "coci_service.err_bad_copy";
    private static final String MSG_WORKING_COPY_LABEL = "coci_service.working_copy_label";
    private static final String MSG_ERR_NOT_OWNER = "coci_service.err_not_owner";
    private static final String MSG_ERR_ALREADY_WORKING_COPY = "coci_service.err_workingcopy_checkout";
    private static final String MSG_ERR_NOT_AUTHENTICATED = "coci_service.err_not_authenticated";
    private static final String MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE = "coci_service.err_workingcopy_has_no_mimetype";
    private static final String MSG_ALREADY_CHECKEDOUT = "coci_service.err_already_checkedout";
    private static final String MSG_ERR_CANNOT_RENAME = "coci_service.err_cannot_rename";
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckOut> beforeCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckOut> onCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCheckIn> beforeCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCheckIn> onCheckIn;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> beforeCancelCheckOut;
    private ClassPolicyDelegate<CheckOutCheckInServicePolicies.OnCancelCheckOut> onCancelCheckOut;
    private static final String EXTENSION_CHARACTER = ".";
    private NodeService nodeService;
    private VersionService versionService;
    private LockService lockService;
    private CopyService copyService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private PolicyComponent policyComponent;
    private AuthenticationService authenticationService;
    private RuleService ruleService;
    private VersionableAspect versionableAspect;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setVersionableAspect(VersionableAspect versionableAspect) {
        this.versionableAspect = versionableAspect;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.beforeCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckOut.class);
        this.onCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckOut.class);
        this.beforeCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCheckIn.class);
        this.onCheckIn = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCheckIn.class);
        this.beforeCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.BeforeCancelCheckOut.class);
        this.onCancelCheckOut = this.policyComponent.registerClassPolicy(CheckOutCheckInServicePolicies.OnCancelCheckOut.class);
    }

    private List<QName> getInvokeClasses(NodeRef nodeRef) {
        ArrayList<QName> result = new ArrayList<QName>(10);
        result.add(this.nodeService.getType(nodeRef));
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            result.add(aspect);
        }
        return result;
    }

    private void invokeBeforeCheckOut(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckOut> policies = this.beforeCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckOut policy : policies) {
                policy.beforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
            }
        }
    }

    private void invokeOnCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckOut> policies = this.onCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckOut policy : policies) {
                policy.onCheckOut(workingCopy);
            }
        }
    }

    private void invokeBeforeCheckIn(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        List<QName> classes = this.getInvokeClasses(workingCopyNodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCheckIn> policies = this.beforeCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCheckIn policy : policies) {
                policy.beforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
            }
        }
    }

    private void invokeOnCheckIn(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCheckIn> policies = this.onCheckIn.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCheckIn policy : policies) {
                policy.onCheckIn(nodeRef);
            }
        }
    }

    private void invokeBeforeCancelCheckOut(NodeRef workingCopy) {
        List<QName> classes = this.getInvokeClasses(workingCopy);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.BeforeCancelCheckOut> policies = this.beforeCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.BeforeCancelCheckOut policy : policies) {
                policy.beforeCancelCheckOut(workingCopy);
            }
        }
    }

    private void invokeOnCancelCheckOut(NodeRef nodeRef) {
        List<QName> classes = this.getInvokeClasses(nodeRef);
        for (QName invokeClass : classes) {
            Collection<CheckOutCheckInServicePolicies.OnCancelCheckOut> policies = this.onCancelCheckOut.getList(invokeClass);
            for (CheckOutCheckInServicePolicies.OnCancelCheckOut policy : policies) {
                policy.onCancelCheckOut(nodeRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef checkout(final NodeRef nodeRef, final NodeRef destinationParentNodeRef, final QName destinationAssocTypeQName, QName destinationAssocQName) {
        LockType lockType = this.lockService.getLockType(nodeRef);
        if (LockType.READ_ONLY_LOCK.equals((Object)lockType) || this.getWorkingCopy(nodeRef) != null) {
            throw new CheckOutCheckInServiceException(MSG_ALREADY_CHECKEDOUT);
        }
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new CheckOutCheckInServiceException(MSG_ERR_ALREADY_WORKING_COPY);
        }
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
        this.invokeBeforeCheckOut(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
        String copyName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        copyName = this.createWorkingCopyName(copyName);
        final QName copyQName = QName.createQName((String)destinationAssocQName.getNamespaceURI(), (String)QName.createValidLocalName((String)copyName));
        NodeRef workingCopy = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef workingCopy = CheckOutCheckInServiceImpl.this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, copyQName);
                return workingCopy;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        String userName = this.getUserName();
        this.ruleService.disableRules();
        try {
            this.nodeService.setProperty(workingCopy, ContentModel.PROP_NAME, (Serializable)((Object)copyName));
            HashMap<QName, String> workingCopyProperties = new HashMap<QName, String>(1);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, userName);
            this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
            Object var12_11 = null;
            this.ruleService.enableRules();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.ruleService.enableRules();
            throw throwable;
        }
        this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        this.invokeOnCheckOut(workingCopy);
        return workingCopy;
    }

    private String getUserName() {
        String un = this.authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new CheckOutCheckInServiceException(MSG_ERR_NOT_AUTHENTICATED);
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef) {
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        return this.checkout(nodeRef, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        NodeRef nodeRef = null;
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        if (this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_COPIEDFROM)) {
            this.invokeBeforeCheckIn(workingCopyNodeRef, versionProperties, contentUrl, keepCheckedOut);
            Map workingCopyProperties = this.nodeService.getProperties(workingCopyNodeRef);
            nodeRef = (NodeRef)workingCopyProperties.get(ContentModel.PROP_COPY_REFERENCE);
            if (nodeRef == null) {
                throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
            }
            try {
                this.lockService.unlock(nodeRef);
            }
            catch (UnableToReleaseLockException exception) {
                throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
            }
            if (contentUrl != null) {
                ContentData contentData = (ContentData)workingCopyProperties.get(ContentModel.PROP_CONTENT);
                if (contentData == null) {
                    throw new AlfrescoRuntimeException(MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE, new Object[]{workingCopyNodeRef});
                }
                contentData = new ContentData(contentUrl, contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
                this.nodeService.setProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
            }
            this.copyService.copy(workingCopyNodeRef, nodeRef);
            if (this.fileFolderService.getFileInfo(workingCopyNodeRef) != null) {
                String origName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                String name = (String)((Object)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_NAME));
                if (this.hasWorkingCopyNameChanged(name, origName)) {
                    if (!name.contains(" " + this.getWorkingCopyLabel())) {
                        try {
                            this.fileFolderService.rename(workingCopyNodeRef, this.createWorkingCopyName(name));
                        }
                        catch (FileExistsException e) {
                            throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, this.createWorkingCopyName(name));
                        }
                        catch (FileNotFoundException e) {
                            throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, this.createWorkingCopyName(name));
                        }
                    }
                    try {
                        this.fileFolderService.rename(nodeRef, this.getNameFromWorkingCopyName(name));
                    }
                    catch (FileExistsException e) {
                        throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, origName, this.getNameFromWorkingCopyName(name));
                    }
                    catch (FileNotFoundException e) {
                        throw new CheckOutCheckInServiceException(e, MSG_ERR_CANNOT_RENAME, name, this.getNameFromWorkingCopyName(name));
                    }
                }
            }
            if (versionProperties != null && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.versionService.createVersion(nodeRef, versionProperties);
            }
            if (!keepCheckedOut) {
                this.nodeService.deleteNode(workingCopyNodeRef);
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
            } else {
                this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
            }
        } else {
            throw new AspectMissingException(ContentModel.ASPECT_COPIEDFROM, workingCopyNodeRef);
        }
        this.invokeOnCheckIn(nodeRef);
        return nodeRef;
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl) {
        return this.checkin(workingCopyNodeRef, versionProperties, contentUrl, false);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties) {
        return this.checkin(workingCopyNodeRef, versionProperties, null, false);
    }

    @Override
    public NodeRef cancelCheckout(NodeRef workingCopyNodeRef) {
        NodeRef nodeRef = null;
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        if (this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_COPIEDFROM)) {
            this.invokeBeforeCancelCheckOut(workingCopyNodeRef);
            nodeRef = (NodeRef)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_COPY_REFERENCE);
            if (nodeRef == null) {
                throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
            }
        } else {
            throw new AspectMissingException(ContentModel.ASPECT_COPIEDFROM, workingCopyNodeRef);
        }
        this.lockService.unlock(nodeRef);
        this.nodeService.deleteNode(workingCopyNodeRef);
        this.invokeOnCancelCheckOut(nodeRef);
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NodeRef getWorkingCopy(NodeRef nodeRef) {
        NodeRef workingCopy = null;
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(nodeRef.getStoreRef(), "lucene", "+ASPECT:\"" + ContentModel.ASPECT_WORKING_COPY.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_COPY_REFERENCE.getLocalName() + ":\"" + nodeRef.toString() + "\"");
            if (resultSet.getNodeRefs().size() != 0) {
                workingCopy = resultSet.getNodeRef(0);
            }
            Object var5_4 = null;
            if (resultSet == null) return workingCopy;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return workingCopy;
    }

    public String createWorkingCopyName(String name) {
        if (this.getWorkingCopyLabel() != null && this.getWorkingCopyLabel().length() != 0) {
            int index;
            name = name != null && name.length() != 0 ? ((index = name.lastIndexOf(EXTENSION_CHARACTER)) > 0 ? name.substring(0, index) + " " + this.getWorkingCopyLabel() + name.substring(index) : name + " " + this.getWorkingCopyLabel()) : this.getWorkingCopyLabel();
        }
        return name;
    }

    private String getNameFromWorkingCopyName(String workingCopyName) {
        String workingCopyLabel = this.getWorkingCopyLabel();
        String workingCopyLabelRegEx = workingCopyLabel.replaceAll("\\(", "\\\\(");
        workingCopyLabelRegEx = workingCopyLabelRegEx.replaceAll("\\)", "\\\\)");
        if (workingCopyName.contains(" " + workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(" " + workingCopyLabelRegEx, "");
        } else if (workingCopyName.contains(workingCopyLabel)) {
            workingCopyName = workingCopyName.replaceFirst(workingCopyLabelRegEx, "");
        }
        return workingCopyName;
    }

    private boolean hasWorkingCopyNameChanged(String workingCopyName, String origName) {
        return !workingCopyName.equals(this.createWorkingCopyName(origName));
    }

    public String getWorkingCopyLabel() {
        return I18NUtil.getMessage((String)MSG_WORKING_COPY_LABEL);
    }
}

