/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.tenant.TenantService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TenantRoutingFileContentStore
extends AbstractRoutingContentStore
implements TenantDeployer,
ApplicationContextAware {
    Map<String, FileContentStore> tenantFileStores = new ConcurrentHashMap<String, FileContentStore>();
    private String defaultRootDirectory;
    private TenantService tenantService;
    private ApplicationContext applicationContext;

    public void setDefaultRootDir(String defaultRootDirectory) {
        this.defaultRootDirectory = defaultRootDirectory;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected ContentStore selectWriteStore(ContentContext ctx) {
        return this.getTenantFileStore(this.tenantService.getCurrentUserDomain());
    }

    @Override
    public List<ContentStore> getAllStores() {
        String currentUser;
        if (this.tenantService.isEnabled() && ((currentUser = AuthenticationUtil.getFullyAuthenticatedUser()) == null || this.tenantService.getBaseNameUser(currentUser).equals(AuthenticationUtil.getSystemUserName()))) {
            ArrayList<ContentStore> allEnabledStores = new ArrayList<ContentStore>();
            for (String tenantDomain : this.tenantFileStores.keySet()) {
                allEnabledStores.add(this.tenantFileStores.get(tenantDomain));
            }
            return allEnabledStores;
        }
        return Arrays.asList(this.getTenantFileStore(this.tenantService.getCurrentUserDomain()));
    }

    private ContentStore getTenantFileStore(String tenantDomain) {
        ContentStore cs = this.tenantFileStores.get(tenantDomain);
        if (cs == null) {
            this.init();
            cs = this.tenantFileStores.get(tenantDomain);
        }
        return cs;
    }

    private void putTenantFileStore(String tenantDomain, FileContentStore fileStore) {
        this.tenantFileStores.put(tenantDomain, fileStore);
    }

    private void removeTenantFileStore(String tenantDomain) {
        this.tenantFileStores.remove(tenantDomain);
    }

    public void init() {
        String tenantDomain = "";
        String rootDir = this.defaultRootDirectory;
        Tenant tenant = this.tenantService.getTenant(this.tenantService.getCurrentUserDomain());
        if (tenant != null) {
            if (tenant.getRootContentStoreDir() != null) {
                rootDir = tenant.getRootContentStoreDir();
            }
            tenantDomain = tenant.getTenantDomain();
        }
        this.putTenantFileStore(tenantDomain, new FileContentStore(this.applicationContext, new File(rootDir)));
    }

    public void destroy() {
        this.removeTenantFileStore(this.tenantService.getCurrentUserDomain());
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public String getDefaultRootDir() {
        return this.defaultRootDirectory;
    }
}

