/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.nio.ByteBuffer;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;

public class FileContentStoreTest
extends AbstractWritableContentStoreTest {
    private FileContentStore store;

    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        this.store = new FileContentStore(ctx, tempDir.getAbsolutePath() + File.separatorChar + this.getName());
    }

    protected ContentStore getStore() {
        return this.store;
    }

    public void testConcurrentWriteDetection() throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap("Something".getBytes());
        ContentStore store = this.getStore();
        ContentContext firstContentCtx = ContentStore.NEW_CONTENT_CONTEXT;
        ContentWriter firstWriter = store.getWriter(firstContentCtx);
        String contentUrl = firstWriter.getContentUrl();
        ContentContext secondContentCtx = new ContentContext(null, contentUrl);
        try {
            ContentWriter secondWriter = store.getWriter(secondContentCtx);
            FileContentStoreTest.fail((String)("Store must disallow more than one writer onto the same content URL: " + store));
        }
        catch (ContentExistsException e) {
            // empty catch block
        }
    }

    public void testRootLocation() throws Exception {
        ContentStore store = this.getStore();
        String root = store.getRootLocation();
        FileContentStoreTest.assertNotNull((String)"Root value can't be null", (Object)root);
        File dir = new File(root);
        FileContentStoreTest.assertTrue((String)"Root location for FileContentStore must exist", (boolean)dir.exists());
    }

    public void testSpaceUsed() throws Exception {
        ContentStore store = this.getStore();
        store.getWriter(new ContentContext(null, null)).putContent("Test content");
        long size = store.getSpaceUsed();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
    }

    public void testSpaceFree() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceFree();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        FileContentStoreTest.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    public void testSpaceTotal() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceTotal();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        FileContentStoreTest.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }
}

