/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MailMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private MailMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new MailMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : MailMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            MailMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testOutlookMsgExtraction() throws Exception {
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("msg");
        MailMetadataExtracterTest.assertNotNull((String)"quick.msg files should be available from Tests", (Object)sourceFile);
        this.testExtractFromMimetype("application/vnd.ms-outlook");
    }

    @Override
    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)"Kevin Roast", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_ORIGINATOR + " not found for mimetype " + mimetype), (String)"Kevin Roast", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ORIGINATOR))));
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_DESCRIPTION + " not found for mimetype " + mimetype), (String)"Test the content transformer", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION))));
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_SENTDATE + " not found for mimetype " + mimetype), (String)"2007-06-14T09:42:55.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_SENTDATE))));
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_ADDRESSEE + " not found for mimetype " + mimetype), (String)"Kevin Roast", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ADDRESSEE))));
        MailMetadataExtracterTest.assertTrue((String)("Property " + ContentModel.PROP_ADDRESSEES + " not found for mimetype " + mimetype), (properties.get(ContentModel.PROP_ADDRESSEES) != null ? 1 : 0) != 0);
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_ADDRESSEES + " wrong content for mimetype " + mimetype), (String)"kevin.roast@alfresco.org", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ADDRESSEES))));
        MailMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_SUBJECT + " not found for mimetype " + mimetype), (String)"Test the content transformer", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_SUBJECT))));
    }
}

