/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataExtracterRegistry {
    private static final Log logger = LogFactory.getLog(MetadataExtracterRegistry.class);
    private List<MetadataExtracter> extracters = new ArrayList<MetadataExtracter>(10);
    private Map<String, List<MetadataExtracter>> extracterCache = new HashMap<String, List<MetadataExtracter>>(17);
    private Lock extracterCacheReadLock;
    private Lock extracterCacheWriteLock;

    public MetadataExtracterRegistry() {
        ReentrantReadWriteLock extractionCacheLock = new ReentrantReadWriteLock();
        this.extracterCacheReadLock = extractionCacheLock.readLock();
        this.extracterCacheWriteLock = extractionCacheLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        this.extracterCacheWriteLock.lock();
        try {
            this.extracterCache.clear();
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MetadataExtracter extracter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering metadata extracter: " + extracter));
        }
        this.extracterCacheWriteLock.lock();
        try {
            this.extracters.add(extracter);
            this.extracterCache.clear();
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataExtracter getExtracter(String sourceMimetype) {
        List<MetadataExtracter> extractors = null;
        this.extracterCacheReadLock.lock();
        try {
            if (this.extracterCache.containsKey(sourceMimetype)) {
                extractors = this.extracterCache.get(sourceMimetype);
            }
        }
        finally {
            this.extracterCacheReadLock.unlock();
        }
        if (extractors == null) {
            this.extracterCacheWriteLock.lock();
            try {
                extractors = this.findBestExtracters(sourceMimetype);
                this.extracterCache.put(sourceMimetype, extractors);
            }
            finally {
                this.extracterCacheWriteLock.unlock();
            }
        }
        MetadataExtracter liveExtractor = null;
        for (MetadataExtracter extractor : extractors) {
            if (!extractor.isSupported(sourceMimetype)) continue;
            liveExtractor = extractor;
        }
        return liveExtractor;
    }

    private List<MetadataExtracter> findBestExtracters(String sourceMimetype) {
        logger.debug((Object)("Finding extractors for " + sourceMimetype));
        ArrayList<MetadataExtracter> extractors = new ArrayList<MetadataExtracter>(1);
        for (MetadataExtracter extractor : this.extracters) {
            if (!extractor.isSupported(sourceMimetype)) continue;
            extractors.add(extractor);
        }
        return extractors;
    }
}

