/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.selector;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.repo.content.ContentWorker;
import org.alfresco.repo.content.selector.ContentWorkerSelector;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootElementNameContentWorkerSelector<W extends ContentWorker>
extends DefaultHandler
implements ContentWorkerSelector<ContentWorker> {
    private static Log logger = LogFactory.getLog(RootElementNameContentWorkerSelector.class);
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private Set<String> supportedMimetypes = new HashSet<String>();
    private Map<String, W> workersByRootElementName;

    public RootElementNameContentWorkerSelector() {
        this.supportedMimetypes.add("text/xml");
        this.workersByRootElementName = Collections.emptyMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("RootElementNameContentWorkerSelector").append("[ workers=").append(this.workersByRootElementName).append("]");
        return sb.toString();
    }

    public void setSupportedMimetypes(Set<String> supportedMimetypes) {
        this.supportedMimetypes = supportedMimetypes;
    }

    public void setWorkers(Map<String, W> workers) {
        this.workersByRootElementName = workers;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"workers", this.workersByRootElementName);
        PropertyCheck.mandatory((Object)this, (String)"supportedMimetypes", this.supportedMimetypes);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public W getWorker(ContentReader reader) {
        block14: {
            if (!this.supportedMimetypes.contains(reader.getMimetype())) {
                return null;
            }
            worker = null;
            is = null;
            rootElementName = null;
            try {
                is = reader.getContentInputStream();
                saxParser = this.saxParserFactory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this);
                var7_8 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var6_14) {
                var7_10 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                throw var6_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (RootElementFoundException e) {
                    rootElementName = e.getElementName();
                    worker = (ContentWorker)this.workersByRootElementName.get(rootElementName);
                    var7_9 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {}
                    }
                    break block14;
                }
                catch (Throwable e) {
                    throw new ContentIOException("\nFailed to extract root element from XML document: \n   Reader:   " + reader + "\n" + "   Selector: " + this, e);
                }
            }
        }
        if (RootElementNameContentWorkerSelector.logger.isDebugEnabled()) {
            RootElementNameContentWorkerSelector.logger.debug((Object)("\nChosen content worker for reader: \n   Reader:       " + reader + "\n" + "   Root Element: " + rootElementName + "\n" + "   Worker:       " + worker));
        }
        return (W)worker;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        throw new RootElementFoundException(qName);
    }

    private static class RootElementFoundException
    extends SAXException {
        private static final long serialVersionUID = 6845880422947198814L;
        private String elementName;

        public RootElementFoundException(String elementName) {
            super(elementName);
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

