/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class EMLTransformer
extends AbstractContentTransformer2 {
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "message/rfc822".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), is);
            StringBuilder sb = new StringBuilder();
            Object content = mimeMessage.getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                BodyPart part = multipart.getBodyPart(0);
                if (part.getContent() instanceof Multipart) {
                    multipart = (Multipart)part.getContent();
                    int n = multipart.getCount();
                    for (int i = 0; i < n; ++i) {
                        part = multipart.getBodyPart(i);
                        if (!part.getContentType().contains("text")) continue;
                        sb.append(part.getContent().toString()).append("\n");
                    }
                } else if (part.getContentType().contains("text")) {
                    sb.append(part.getContent().toString());
                }
            } else {
                sb.append(content.toString());
            }
            writer.putContent(sb.toString());
            Object var13_12 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

