/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.io.File;
import java.util.ArrayList;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentReport;
import org.alfresco.service.cmr.avm.deploy.DeploymentReportCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.util.NameMatcher;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DeploymentServiceTest
extends AbstractWCMServiceImplTest {
    private static Log logger = LogFactory.getLog(DeploymentServiceTest.class);
    private static final String TEST_SANDBOX = TEST_WEBPROJ_DNS + "-sandbox";
    private static final int SCALE_USERS = 5;
    private static final int SCALE_WEBPROJECTS = 2;
    private AVMService avmService;
    private DeploymentService deploymentService = null;
    private NameMatcher matcher = null;
    private File log = null;
    private File metadata = null;
    private File data = null;
    private File target = null;
    private String TEST_USER = "Giles";
    private String TEST_PASSWORD = "Watcher";
    private String TEST_TARGET = "sampleTarget";

    protected void setUp() throws Exception {
        super.setUp();
        this.avmService = (AVMService)ctx.getBean("AVMService");
        this.deploymentService = (DeploymentService)ctx.getBean("DeploymentService");
        NameMatcher matcher = (NameMatcher)ctx.getBean("globalPathExcluder");
        super.setUp();
        this.log = new File("deplog");
        this.log.mkdir();
        this.metadata = new File("depmetadata");
        this.metadata.mkdir();
        this.data = new File("depdata");
        this.data.mkdir();
        this.target = new File("sampleTarget");
        this.target.mkdir();
        FileSystemXmlApplicationContext receiverContext = new FileSystemXmlApplicationContext("../deployment/config/application-context.xml");
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteUser(USER_FOUR);
        super.tearDown();
    }

    public void testSimple() throws Exception {
        int storeCnt = this.avmService.getStores().size();
        String projectName = "DeploymentServiceTestSimple";
        WebProjectInfo wpInfo = this.wpService.createWebProject(projectName, projectName, "This is my title", "This is my description", "ROOT", false, null);
        String wpStoreId = wpInfo.getStoreId();
        DeploymentServiceTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        DeploymentServiceTest.assertEquals((int)(storeCnt + 4), (int)this.avmService.getStores().size());
        SandboxInfo authorInfo = this.sbService.getAuthorSandbox(wpStoreId);
        DeploymentServiceTest.assertNotNull((Object)authorInfo);
        SandboxInfo stagingInfo = this.sbService.getStagingSandbox(wpStoreId);
        DeploymentServiceTest.assertNotNull((Object)stagingInfo);
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        String srcPath = projectName + "--admin:/www/avm_webapps";
        this.deploymentService.deployDifferenceFS(-1, srcPath, "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, this.matcher, false, false, false, callbacks);
        this.assetService.createFolder(authorInfo.getSandboxId(), "/", "hello", null);
        srcPath = projectName + "--admin:/www/avm_webapps/ROOT";
        this.deploymentService.deployDifferenceFS(-1, srcPath, "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, this.matcher, false, false, false, callbacks);
        srcPath = projectName + ":/www/avm_webapps/ROOT";
        this.deploymentService.deployDifferenceFS(-1, srcPath, "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, this.matcher, false, false, false, callbacks);
        this.wpService.deleteWebProject(projectName);
    }
}

