/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.domain.avm.AVMStorePropertyEntity;
import org.alfresco.repo.domain.avm.AbstractAVMStoreDAOImpl;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMStoreDAOImpl
extends AbstractAVMStoreDAOImpl {
    private static final String SELECT_AVM_STORE_BY_ID = "alfresco.avm.select_AVMStoreById";
    private static final String SELECT_AVM_STORE_BY_KEY = "alfresco.avm.select_AVMStoreByKey";
    private static final String SELECT_AVM_STORE_BY_KEY_L = "alfresco.avm.select_AVMStoreByKeyL";
    private static final String SELECT_AVM_STORE_BY_ROOT_NODE_ID = "alfresco.avm.select_AVMStoreByRootNodeId";
    private static final String SELECT_AVM_STORE_ALL = "alfresco.avm.select_AVMStoreAll";
    private static final String INSERT_AVM_STORE = "alfresco.avm.insert_AVMStore";
    private static final String DELETE_AVM_STORE = "alfresco.avm.delete_AVMStore";
    private static final String UPDATE_AVM_STORE = "alfresco.avm.update_AVMStore";
    private static final String INSERT_AVM_STORE_PROP = "alfresco.avm.insert_AVMStoreProperty";
    private static final String UPDATE_AVM_STORE_PROP = "alfresco.avm.update_AVMStoreProperty";
    private static final String SELECT_AVM_STORE_PROP = "alfresco.avm.select_AVMStoreProperty";
    private static final String SELECT_AVM_STORE_PROPS = "alfresco.avm.select_AVMStoreProperties";
    private static final String SELECT_AVM_STORE_PROPS_BY_KEY_PATTERN = "alfresco.avm.select_AVMStorePropertiesByKeyPattern";
    private static final String SELECT_AVM_STORE_PROPS_BY_KEY_PATTERN_L = "alfresco.avm.select_AVMStorePropertiesByKeyPatternL";
    private static final String SELECT_AVM_STORE_PROPS_BY_STORE_AND_KEY_PATTERN = "alfresco.avm.select_AVMStorePropertiesByStoreAndKeyPattern";
    private static final String SELECT_AVM_STORE_PROPS_BY_STORE_AND_KEY_PATTERN_L = "alfresco.avm.select_AVMStorePropertiesByStoreAndKeyPatternL";
    private static final String DELETE_AVM_STORE_PROP = "alfresco.avm.delete_AVMStoreProperty";
    private static final String DELETE_AVM_STORE_PROPS = "alfresco.avm.delete_AVMStoreProperties";
    private SqlMapClientTemplate template;
    private boolean toLower = true;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    public void setToLower(boolean toLower) {
        this.toLower = toLower;
    }

    @Override
    protected AVMStoreEntity getStoreEntity(long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", id);
        return (AVMStoreEntity)this.template.queryForObject(SELECT_AVM_STORE_BY_ID, params);
    }

    @Override
    protected AVMStoreEntity getStoreEntity(String name) {
        AVMStoreEntity storeEntity = new AVMStoreEntity();
        storeEntity.setName(name);
        if (this.toLower) {
            return (AVMStoreEntity)this.template.queryForObject(SELECT_AVM_STORE_BY_KEY_L, (Object)storeEntity);
        }
        return (AVMStoreEntity)this.template.queryForObject(SELECT_AVM_STORE_BY_KEY, (Object)storeEntity);
    }

    @Override
    protected AVMStoreEntity getStoreEntityByRoot(long rootNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", rootNodeId);
        return (AVMStoreEntity)this.template.queryForObject(SELECT_AVM_STORE_BY_ROOT_NODE_ID, params);
    }

    @Override
    protected List<AVMStoreEntity> getAllStoreEntities() {
        return this.template.queryForList(SELECT_AVM_STORE_ALL);
    }

    @Override
    protected AVMStoreEntity createStoreEntity(AVMStoreEntity storeEntity) {
        Long id = (Long)this.template.insert(INSERT_AVM_STORE, (Object)storeEntity);
        storeEntity.setId(id);
        return storeEntity;
    }

    @Override
    protected int updateStoreEntity(AVMStoreEntity updateStoreEntity) {
        updateStoreEntity.incrementVers();
        return this.template.update(UPDATE_AVM_STORE, (Object)updateStoreEntity);
    }

    @Override
    protected int deleteStoreEntity(long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", id);
        return this.template.delete(DELETE_AVM_STORE, params);
    }

    @Override
    protected void insertStorePropertyEntity(AVMStorePropertyEntity propEntity) {
        this.template.insert(INSERT_AVM_STORE_PROP, (Object)propEntity);
    }

    @Override
    protected int updateStorePropertyEntity(AVMStorePropertyEntity updatePropEntity) {
        return this.template.update(UPDATE_AVM_STORE_PROP, (Object)updatePropEntity);
    }

    @Override
    protected AVMStorePropertyEntity getStorePropertyEntity(long storeId, long qnameId) {
        AVMStorePropertyEntity propEntity = new AVMStorePropertyEntity();
        propEntity.setAvmStoreId(storeId);
        propEntity.setQnameId(qnameId);
        return (AVMStorePropertyEntity)this.template.queryForObject(SELECT_AVM_STORE_PROP, (Object)propEntity);
    }

    @Override
    protected List<AVMStorePropertyEntity> getStorePropertyEntities(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        try {
            return this.template.queryForList(SELECT_AVM_STORE_PROPS, params);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to query for store properties: " + params, e);
        }
    }

    @Override
    protected List<AVMStorePropertyEntity> getStorePropertyEntitiesByKeyPattern(String uriPattern, String localNamePattern) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("uri", uriPattern);
        params.put("localname", localNamePattern);
        if (this.toLower) {
            return this.template.queryForList(SELECT_AVM_STORE_PROPS_BY_KEY_PATTERN_L, params);
        }
        return this.template.queryForList(SELECT_AVM_STORE_PROPS_BY_KEY_PATTERN, params);
    }

    @Override
    protected List<AVMStorePropertyEntity> getStorePropertyEntitiesByStoreAndKeyPattern(long storeId, String uriPattern, String localNamePattern) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("id", storeId);
        params.put("uri", uriPattern);
        params.put("localname", localNamePattern);
        if (this.toLower) {
            return this.template.queryForList(SELECT_AVM_STORE_PROPS_BY_STORE_AND_KEY_PATTERN_L, params);
        }
        return this.template.queryForList(SELECT_AVM_STORE_PROPS_BY_STORE_AND_KEY_PATTERN, params);
    }

    @Override
    protected int deleteStorePropertyEntity(long storeId, long qnameId) {
        AVMStorePropertyEntity propEntity = new AVMStorePropertyEntity();
        propEntity.setAvmStoreId(storeId);
        propEntity.setQnameId(qnameId);
        return this.template.delete(DELETE_AVM_STORE_PROP, (Object)propEntity);
    }

    @Override
    protected int deleteStorePropertyEntities(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        return this.template.delete(DELETE_AVM_STORE_PROPS, params);
    }
}

