/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

public class NodeDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private NodeDAO nodeDAO;

    public void setUp() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.txnHelper.setMinRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(10);
        this.txnHelper.setMaxRetryWaitMs(50);
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
    }

    public void testTransaction() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> getTxnIdCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return NodeDAOTest.this.nodeDAO.getCurrentTransactionId();
            }
        };
        try {
            getTxnIdCallback.execute();
            NodeDAOTest.fail((String)"Should have failed when running outside of a transaction");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.txnHelper.doInTransaction(getTxnIdCallback, true);
            NodeDAOTest.fail((String)"Should have failed when running in read-only transaction");
        }
        catch (Throwable e) {
            // empty catch block
        }
        Long txnId1 = this.txnHelper.doInTransaction(getTxnIdCallback);
        NodeDAOTest.assertNotNull((String)"No txn ID 1", (Object)txnId1);
        Long txnId2 = this.txnHelper.doInTransaction(getTxnIdCallback);
        NodeDAOTest.assertNotNull((String)"No txn ID 2", (Object)txnId2);
        NodeDAOTest.assertTrue((String)"2nd ID should be larger than first", (txnId2.compareTo(txnId1) > 0 ? 1 : 0) != 0);
    }

    public void xtestNewStore() throws Exception {
        final StoreRef storeRef = new StoreRef("test", this.getName() + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, NodeRef>>(){

            @Override
            public Pair<Long, NodeRef> execute() throws Throwable {
                return NodeDAOTest.this.nodeDAO.newStore(storeRef);
            }
        };
        Pair<Long, NodeRef> rootNodePair = this.txnHelper.doInTransaction(callback);
        NodeDAOTest.assertNotNull(rootNodePair);
        NodeDAOTest.assertEquals((String)"Root node has incorrect store", (Object)storeRef, (Object)((NodeRef)rootNodePair.getSecond()).getStoreRef());
        try {
            this.txnHelper.doInTransaction(callback);
            NodeDAOTest.fail((String)"Should not be able to create same store.");
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public void testGetNodesWithAspects() throws Throwable {
        NodeDAO.NodeRefQueryCallback callback = new NodeDAO.NodeRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, NodeRef> nodePair) {
                return false;
            }
        };
        this.nodeDAO.getNodesWithAspect(ContentModel.ASPECT_AUDITABLE, 1L, 5, callback);
    }

    public void testGetPrimaryChildAcls() throws Throwable {
        List<NodeIdAndAclId> acls = this.nodeDAO.getPrimaryChildrenAcls(1L);
        NodeDAOTest.assertNotNull((String)"Null list", acls);
    }
}

