/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEntity
implements Node {
    private boolean locked;
    private Long id;
    private Long version;
    private StoreEntity store;
    private String uuid;
    private Long typeQNameId;
    private Long aclId;
    private Boolean deleted;
    private TransactionEntity transaction;
    private AuditablePropertiesEntity auditableProperties;

    public NodeEntity() {
        this.locked = false;
    }

    NodeEntity(NodeRef nodeRef) {
        this();
        this.store = new StoreEntity();
        this.store.setProtocol(nodeRef.getStoreRef().getProtocol());
        this.store.setIdentifier(nodeRef.getStoreRef().getIdentifier());
        this.uuid = nodeRef.getId();
    }

    NodeEntity(Node node) {
        this.id = node.getId();
        this.version = node.getVersion();
        this.store = node.getStore();
        this.uuid = node.getUuid();
        this.typeQNameId = node.getTypeQNameId();
        this.aclId = node.getAclId();
        this.deleted = node.getDeleted();
        this.transaction = node.getTransaction();
        this.auditableProperties = node.getAuditableProperties();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("NodeEntity").append("[ ID=").append(this.id);
        if (this.store != null) {
            sb.append(", store=").append(this.store.getProtocol()).append("://").append(this.store.getIdentifier());
        } else {
            sb.append(", store=").append("null");
        }
        sb.append(", uuid=").append(this.uuid).append(", typeQNameId=").append(this.typeQNameId).append(", aclId=").append(this.aclId).append(", deleted=").append(this.deleted).append(", transaction=").append(this.transaction).append(", auditProps=").append(this.auditableProperties).append("]");
        return sb.toString();
    }

    public void lock() {
        this.locked = true;
    }

    private final void checkLock() {
        if (this.locked) {
            throw new IllegalStateException("The entity is locked against updates: " + this);
        }
    }

    public void incrementVersion() {
        if (this.version >= 32767L) {
            this.version = 0L;
        } else {
            NodeEntity nodeEntity = this;
            Long l = nodeEntity.version;
            Long l2 = nodeEntity.version = Long.valueOf(nodeEntity.version + 1L);
        }
    }

    @Override
    public NodeRef getNodeRef() {
        return new NodeRef(this.store.getStoreRef(), this.uuid);
    }

    public NodeRef.Status getNodeStatus() {
        NodeRef nodeRef = new NodeRef(this.store.getStoreRef(), this.uuid);
        return new NodeRef.Status(nodeRef, this.transaction.getChangeTxnId(), this.transaction.getId(), this.deleted.booleanValue());
    }

    @Override
    public Pair<Long, NodeRef> getNodePair() {
        return new Pair((Object)this.id, (Object)this.getNodeRef());
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.checkLock();
        this.id = id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.checkLock();
        this.version = version;
    }

    @Override
    public StoreEntity getStore() {
        return this.store;
    }

    public void setStore(StoreEntity store) {
        this.checkLock();
        this.store = store;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.checkLock();
        this.uuid = uuid;
    }

    @Override
    public Long getTypeQNameId() {
        return this.typeQNameId;
    }

    public void setTypeQNameId(Long typeQNameId) {
        this.checkLock();
        this.typeQNameId = typeQNameId;
    }

    @Override
    public Long getAclId() {
        return this.aclId;
    }

    public void setAclId(Long aclId) {
        this.checkLock();
        this.aclId = aclId;
    }

    @Override
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.checkLock();
        this.deleted = deleted;
    }

    @Override
    public TransactionEntity getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionEntity transaction) {
        this.checkLock();
        this.transaction = transaction;
    }

    @Override
    public AuditablePropertiesEntity getAuditableProperties() {
        return this.auditableProperties;
    }

    public void setAuditableProperties(AuditablePropertiesEntity auditableProperties) {
        this.checkLock();
        this.auditableProperties = auditableProperties;
    }
}

