/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.permissions.AVMAccessControlListDAO;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMAccessControlListDAO
implements AccessControlListDAO {
    private NodeDAO nodeDAO;
    private AclDAO aclDaoComponent;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    @Override
    public void forceCopy(NodeRef nodeRef) {
    }

    private Long getNodeIdNotNull(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeRef);
        if (nodePair == null) {
            throw new InvalidNodeRefException(nodeRef);
        }
        return (Long)nodePair.getFirst();
    }

    @Override
    public Acl getAccessControlList(NodeRef nodeRef) {
        Long nodeId = this.getNodeIdNotNull(nodeRef);
        Long aclId = this.nodeDAO.getNodeAclId(nodeId);
        return this.aclDaoComponent.getAcl(aclId);
    }

    @Override
    public Acl getAccessControlList(StoreRef storeRef) {
        return null;
    }

    @Override
    public Long getIndirectAcl(NodeRef nodeRef) {
        return this.getAccessControlList(nodeRef).getId();
    }

    @Override
    public Long getInheritedAcl(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeRef);
        if (nodePair == null) {
            return null;
        }
        Pair<Long, ChildAssociationRef> parentAssocRefPair = this.nodeDAO.getPrimaryParentAssoc((Long)nodePair.getFirst());
        if (parentAssocRefPair == null || ((ChildAssociationRef)parentAssocRefPair.getSecond()).getParentRef() == null) {
            return null;
        }
        Acl acl = this.getAccessControlList(((ChildAssociationRef)parentAssocRefPair.getSecond()).getParentRef());
        if (acl != null) {
            return acl.getId();
        }
        return null;
    }

    @Override
    public Map<ACLType, Integer> patchAcls() {
        AVMAccessControlListDAO.CounterSet result = new AVMAccessControlListDAO.CounterSet();
        List<Pair<Long, StoreRef>> stores = this.nodeDAO.getStores();
        for (Pair<Long, StoreRef> pair : stores) {
            if (((StoreRef)pair.getSecond()).getProtocol().equals("avm")) continue;
            Long rootNodeId = (Long)this.nodeDAO.getRootNode((StoreRef)pair.getSecond()).getFirst();
            AVMAccessControlListDAO.CounterSet update = this.fixOldDmAcls(rootNodeId, this.nodeDAO.getNodeAclId(rootNodeId), null, true);
            result.add(update);
        }
        HashMap<ACLType, Integer> toReturn = new HashMap<ACLType, Integer>();
        toReturn.put(ACLType.DEFINING, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.DEFINING)).getCounter());
        toReturn.put(ACLType.FIXED, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.FIXED)).getCounter());
        toReturn.put(ACLType.GLOBAL, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.GLOBAL)).getCounter());
        toReturn.put(ACLType.LAYERED, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.LAYERED)).getCounter());
        toReturn.put(ACLType.OLD, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.OLD)).getCounter());
        toReturn.put(ACLType.SHARED, ((AVMAccessControlListDAO.Counter)result.get((Object)ACLType.SHARED)).getCounter());
        return toReturn;
    }

    private AVMAccessControlListDAO.CounterSet fixOldDmAcls(Long nodeId, Long existingNodeAclId, Long inheritedAclId, boolean isRoot) {
        AVMAccessControlListDAO.CounterSet result = new AVMAccessControlListDAO.CounterSet();
        Long newDefiningAcl = null;
        if (existingNodeAclId == null || existingNodeAclId != inheritedAclId) {
            AccessControlListProperties properties;
            AccessControlList existing = null;
            if (existingNodeAclId != null) {
                existing = this.aclDaoComponent.getAccessControlList(existingNodeAclId);
            }
            if (existing != null) {
                if (existing.getProperties().getAclType() == ACLType.OLD) {
                    result.increment(ACLType.DEFINING);
                    properties = new SimpleAccessControlListProperties(this.aclDaoComponent.getDefaultProperties());
                    ((SimpleAccessControlListProperties)properties).setInherits(existing.getProperties().getInherits());
                    Long actuallyInherited = null;
                    if (existing.getProperties().getInherits().booleanValue() && inheritedAclId != null) {
                        actuallyInherited = inheritedAclId;
                    }
                    Acl newAcl = this.aclDaoComponent.createAccessControlList(properties, existing.getEntries(), actuallyInherited);
                    newDefiningAcl = newAcl.getId();
                    this.nodeDAO.setNodeDefiningAclId(nodeId, newDefiningAcl);
                } else if (existing.getProperties().getAclType() != ACLType.SHARED) {
                    return result;
                }
            } else if (isRoot) {
                result.increment(ACLType.DEFINING);
                properties = this.aclDaoComponent.getDefaultProperties();
                Acl newAcl = this.aclDaoComponent.createAccessControlList(properties);
                newDefiningAcl = newAcl.getId();
                this.nodeDAO.setNodeDefiningAclId(nodeId, newDefiningAcl);
            } else {
                this.nodeDAO.setNodeDefiningAclId(nodeId, inheritedAclId);
            }
        }
        Long toInherit = null;
        List<NodeIdAndAclId> children = this.nodeDAO.getPrimaryChildrenAcls(nodeId);
        if (children.size() > 0) {
            toInherit = newDefiningAcl == null ? inheritedAclId : this.aclDaoComponent.getInheritedAccessControlList(newDefiningAcl);
        }
        if (children.size() > 0) {
            this.nodeDAO.setPrimaryChildrenSharedAclId(nodeId, null, toInherit);
        }
        for (NodeIdAndAclId child : children) {
            AVMAccessControlListDAO.CounterSet update = this.fixOldDmAcls(child.getId(), child.getAclId(), toInherit, false);
            result.add(update);
        }
        return result;
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Long aclId) {
        Long nodeId = this.getNodeIdNotNull(nodeRef);
        this.nodeDAO.setNodeAclId(nodeId, aclId);
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Acl acl) {
        Long aclId = null;
        if (acl != null) {
            aclId = acl.getId();
        }
        this.setAccessControlList(nodeRef, aclId);
    }

    @Override
    public void setAccessControlList(StoreRef storeRef, Acl acl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AclChange> setInheritanceForChildren(NodeRef parent, Long inheritFrom, Long sharedAclToReplace) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.setFixedAcls(this.getNodeIdNotNull(parent), inheritFrom, null, sharedAclToReplace, changes, false);
        return changes;
    }

    @Override
    public void updateChangedAcls(NodeRef startingPoint, List<AclChange> changes) {
    }

    public void setFixedAcls(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set) {
        List<NodeIdAndAclId> children;
        if (nodeId == null) {
            return;
        }
        if (set) {
            if (mergeFrom == null) {
                mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
            }
            this.nodeDAO.setNodeAclId(nodeId, mergeFrom);
        }
        if (mergeFrom == null) {
            mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
        }
        if ((children = this.nodeDAO.getPrimaryChildrenAcls(nodeId)).size() > 0) {
            this.nodeDAO.setPrimaryChildrenSharedAclId(nodeId, sharedAclToReplace, mergeFrom);
        }
        for (NodeIdAndAclId child : children) {
            Long acl;
            if (mergeFrom == null) {
                mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
            }
            if ((acl = child.getAclId()) == null) {
                this.setFixedAcls(child.getId(), inheritFrom, mergeFrom, sharedAclToReplace, changes, false);
                continue;
            }
            if (acl.equals(sharedAclToReplace)) {
                this.setFixedAcls(child.getId(), inheritFrom, mergeFrom, sharedAclToReplace, changes, false);
                continue;
            }
            Acl dbAcl = this.aclDaoComponent.getAcl(acl);
            if (dbAcl.getAclType() == ACLType.LAYERED) {
                throw new UnsupportedOperationException();
            }
            if (dbAcl.getAclType() == ACLType.DEFINING) {
                if (!dbAcl.getInherits().booleanValue()) continue;
                List<AclChange> newChanges = this.aclDaoComponent.mergeInheritedAccessControlList(mergeFrom, acl);
                continue;
            }
            if (dbAcl.getAclType() != ACLType.SHARED) continue;
            throw new IllegalStateException();
        }
    }

    @Override
    public void updateInheritance(Long childNodeId, Long oldParentNodeId, Long newParentNodeId) {
        Long oldParentAclId;
        Acl acl;
        if (oldParentNodeId == null) {
            return;
        }
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        Long newParentAclId = this.nodeDAO.getNodeAclId(newParentNodeId);
        Long childAclId = this.nodeDAO.getNodeAclId(childNodeId);
        if (childAclId == null && newParentAclId != null) {
            Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
            this.setFixedAcls(childNodeId, newParentSharedAclId, null, null, changes, true);
        }
        if ((acl = this.aclDaoComponent.getAcl(childAclId)) != null && acl.getInherits().booleanValue() && (oldParentAclId = this.nodeDAO.getNodeAclId(oldParentNodeId)) != null) {
            Long oldParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(oldParentAclId);
            Long sharedAclchildInheritsFrom = acl.getInheritsFrom();
            if (childAclId.equals(oldParentSharedAclId)) {
                if (newParentAclId != null) {
                    Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
                    this.setFixedAcls(childNodeId, newParentSharedAclId, null, childAclId, changes, true);
                }
            } else if (sharedAclchildInheritsFrom != null && sharedAclchildInheritsFrom.equals(oldParentSharedAclId)) {
                if (acl.getAclType() == ACLType.LAYERED) {
                    throw new UnsupportedOperationException();
                }
                if (acl.getAclType() == ACLType.DEFINING) {
                    Long newParentSharedAclId = this.aclDaoComponent.getInheritedAccessControlList(newParentAclId);
                    List<AclChange> newChanges = this.aclDaoComponent.mergeInheritedAccessControlList(newParentSharedAclId, childAclId);
                } else if (acl.getAclType() == ACLType.SHARED) {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

