/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.AbstractFormProcessor;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.Filter;
import org.alfresco.repo.forms.processor.FilterRegistry;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.FormCreationDataImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredFormProcessor<ItemType, PersistType>
extends AbstractFormProcessor {
    private static final Log logger = LogFactory.getLog(FilteredFormProcessor.class);
    private List<String> ignoredFields = null;
    protected FilterRegistry<ItemType, PersistType> filterRegistry;
    protected FieldProcessorRegistry fieldProcessorRegistry;

    public void setFilterRegistry(FilterRegistry<ItemType, PersistType> filterRegistry) {
        this.filterRegistry = filterRegistry;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set filter registry: " + this.filterRegistry + " for processor: " + this));
        }
    }

    public void setIgnoredFields(List<String> ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    @Override
    public Form generate(Item item, List<String> fields, List<String> forcedFields, Map<String, Object> context) {
        ItemType typedItem = this.getTypedItem(item);
        Form form = new Form(item);
        if (this.filterRegistry != null) {
            for (Filter<ItemType, PersistType> filter : this.filterRegistry.getFilters()) {
                filter.beforeGenerate(typedItem, fields, forcedFields, form, context);
            }
        }
        this.internalGenerate(typedItem, fields, forcedFields, form, context);
        if (this.filterRegistry != null) {
            for (Filter<ItemType, PersistType> filter : this.filterRegistry.getFilters()) {
                filter.afterGenerate(typedItem, fields, forcedFields, form, context);
            }
        }
        return form;
    }

    @Override
    public Object persist(Item item, FormData data) {
        ItemType typedItem = this.getTypedItem(item);
        if (this.filterRegistry != null) {
            for (Filter<ItemType, PersistType> filter : this.filterRegistry.getFilters()) {
                filter.beforePersist(typedItem, data);
            }
        }
        PersistType persistedObject = this.internalPersist(typedItem, data);
        if (this.filterRegistry != null) {
            for (Filter<ItemType, PersistType> filter : this.filterRegistry.getFilters()) {
                filter.afterPersist(typedItem, data, persistedObject);
            }
        }
        return persistedObject;
    }

    protected void internalGenerate(ItemType item, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
        Log log = this.getLogger();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating form for: " + item));
        }
        Item formItem = form.getItem();
        formItem.setType(this.getItemType(item));
        formItem.setUrl(this.getItemURI(item));
        Object itemData = this.makeItemData(item);
        FormCreationDataImpl data = new FormCreationDataImpl(itemData, forcedFields, context);
        this.populateForm(form, fields, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated form: " + form));
        }
    }

    protected void populateForm(Form form, List<String> fields, FormCreationData data) {
        List<Field> fieldsToAdd = fields != null && fields.size() > 0 ? this.generateSelectedFields(fields, data) : this.generateDefaultFields(data, this.getIgnoredFields());
        form.addFields(fieldsToAdd);
    }

    private List<String> getIgnoredFields() {
        if (this.ignoredFields != null) {
            return this.ignoredFields;
        }
        return this.getDefaultIgnoredFields();
    }

    protected List<Field> generateDefaultFields(FormCreationData data, List<String> fieldsToIgnore) {
        return Collections.emptyList();
    }

    protected List<Field> generateSelectedFields(List<String> fields, FormCreationData data) {
        ArrayList<Field> fieldData = new ArrayList<Field>(fields.size());
        for (String fieldName : fields) {
            Field field = this.fieldProcessorRegistry.buildField(fieldName, data);
            if (field == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                String msg = "Ignoring unrecognised field \"" + fieldName + "\"";
                this.getLogger().debug((Object)msg);
                continue;
            }
            fieldData.add(field);
        }
        return fieldData;
    }

    public void setFieldProcessorRegistry(FieldProcessorRegistry fieldProcessorRegistry) {
        this.fieldProcessorRegistry = fieldProcessorRegistry;
    }

    protected abstract Object makeItemData(ItemType var1);

    protected abstract ItemType getTypedItem(Item var1);

    protected abstract Log getLogger();

    protected abstract String getItemType(ItemType var1);

    protected abstract String getItemURI(ItemType var1);

    protected abstract PersistType internalPersist(ItemType var1, FormData var2);

    protected abstract List<String> getDefaultIgnoredFields();
}

