/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageServiceImpl
implements MessageService {
    private static final Log logger = LogFactory.getLog(MessageServiceImpl.class);
    public static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private TenantService tenantService;
    private SearchService searchService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SimpleCache<String, Set<String>> resourceBundleBaseNamesCache;
    private SimpleCache<String, Map<Locale, Set<String>>> loadedResourceBundlesCache;
    private SimpleCache<String, Map<Locale, Map<String, String>>> messagesCache;
    private List<MessageDeployer> messageDeployers = new ArrayList<MessageDeployer>();

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setResourceBundleBaseNamesCache(SimpleCache<String, Set<String>> resourceBundleBaseNamesCache) {
        this.resourceBundleBaseNamesCache = resourceBundleBaseNamesCache;
    }

    public void setLoadedResourceBundlesCache(SimpleCache<String, Map<Locale, Set<String>>> loadedResourceBundlesCache) {
        this.loadedResourceBundlesCache = loadedResourceBundlesCache;
    }

    public void setMessagesCache(SimpleCache<String, Map<Locale, Map<String, String>>> messagesCache) {
        this.messagesCache = messagesCache;
    }

    @Override
    public void setLocale(Locale locale) {
        I18NUtil.setLocale((Locale)locale);
    }

    @Override
    public Locale getLocale() {
        return I18NUtil.getLocale();
    }

    @Override
    public void setContentLocale(Locale locale) {
        I18NUtil.setContentLocale((Locale)locale);
    }

    @Override
    public Locale getContentLocale() {
        return I18NUtil.getContentLocale();
    }

    @Override
    public Locale getNearestLocale(Locale templateLocale, Set<Locale> options) {
        return I18NUtil.getNearestLocale((Locale)templateLocale, options);
    }

    @Override
    public Locale parseLocale(String localeStr) {
        return I18NUtil.parseLocale((String)localeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResourceBundle(String resBundlePath) {
        String tenantDomain = this.getTenantDomain();
        Set<String> tenantResourceBundleBaseNames = null;
        try {
            this.readLock.lock();
            tenantResourceBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain);
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
        try {
            this.writeLock.lock();
            if (!tenantResourceBundleBaseNames.contains(resBundlePath)) {
                tenantResourceBundleBaseNames.add(resBundlePath);
            }
            logger.info((Object)("Registered message bundle '" + resBundlePath + "'"));
            this.clearLoadedResourceBundles(tenantDomain);
            Object var7_7 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    @Override
    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, this.getLocale());
    }

    @Override
    public String getMessage(final String messageKey, final Locale locale) {
        String message = null;
        Map<String, String> props = this.getLocaleProperties(locale);
        if (props != null) {
            message = props.get(messageKey);
        }
        if (message == null) {
            if (this.tenantService.isTenantUser()) {
                message = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                    public String doWork() throws Exception {
                        String message = null;
                        Map props = MessageServiceImpl.this.getLocaleProperties(locale);
                        if (props != null) {
                            message = (String)props.get(messageKey);
                        }
                        return message;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
            if (message == null) {
                message = I18NUtil.getMessage((String)this.tenantService.getBaseName(messageKey));
            }
        }
        return message;
    }

    @Override
    public String getMessage(String messageKey, Object ... params) {
        return this.getMessage(messageKey, this.getLocale(), params);
    }

    @Override
    public String getMessage(String messageKey, Locale locale, Object ... params) {
        String message = this.getMessage(messageKey, locale);
        if (message != null && params != null) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterResourceBundle(String resBundlePath) {
        Set<String> resourceBundleBaseNamesForAllLocales;
        Map<Locale, Map<String, String>> cachedMessagesForAllLocales;
        Map<Locale, Set<String>> loadedResourceBundlesForAllLocales;
        String tenantDomain = this.getTenantDomain();
        try {
            this.readLock.lock();
            loadedResourceBundlesForAllLocales = this.getLoadedResourceBundles(tenantDomain);
            cachedMessagesForAllLocales = this.getMessages(tenantDomain);
            resourceBundleBaseNamesForAllLocales = this.getResourceBundleBaseNames(tenantDomain);
            Object var7_6 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
        try {
            this.writeLock.lock();
            if (loadedResourceBundlesForAllLocales != null && cachedMessagesForAllLocales != null) {
                for (Locale locale : loadedResourceBundlesForAllLocales.keySet()) {
                    Set<String> loadedBundles = loadedResourceBundlesForAllLocales.get(locale);
                    Map<String, String> props = cachedMessagesForAllLocales.get(locale);
                    if (loadedBundles == null || props == null || !loadedBundles.contains(resBundlePath)) continue;
                    ResourceBundle resourcebundle = null;
                    int idx1 = resBundlePath.indexOf("://");
                    if (idx1 != -1) {
                        int idx2 = resBundlePath.indexOf("/", idx1 + 3);
                        String store = resBundlePath.substring(0, idx2);
                        String path = resBundlePath.substring(idx2);
                        StoreRef storeRef = this.tenantService.getName(new StoreRef(store));
                        try {
                            resourcebundle = this.getRepoResourceBundle(storeRef, path, locale);
                        }
                        catch (IOException ioe) {
                            throw new AlfrescoRuntimeException("Failed to read message resource bundle from repository " + resBundlePath + " : " + ioe);
                        }
                    } else {
                        resourcebundle = ResourceBundle.getBundle(resBundlePath, locale);
                    }
                    if (resourcebundle != null) {
                        Enumeration<String> enumKeys = resourcebundle.getKeys();
                        while (enumKeys.hasMoreElements()) {
                            String key = enumKeys.nextElement();
                            props.remove(key);
                        }
                    }
                    loadedBundles.remove(resBundlePath);
                }
            }
            if (resourceBundleBaseNamesForAllLocales != null) {
                resourceBundleBaseNamesForAllLocales.remove(resBundlePath);
                logger.info((Object)("Unregistered message bundle '" + resBundlePath + "'"));
            }
            this.clearLoadedResourceBundles(tenantDomain);
            Object var18_20 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getLocaleProperties(Locale locale) {
        Set<String> loadedBundles = null;
        Map<String, String> props = null;
        int loadedBundleCount = 0;
        String tenantDomain = this.getTenantDomain();
        boolean init = false;
        Map<Locale, Set<String>> tenantLoadedResourceBundles = null;
        Map<Locale, Map<String, String>> tenantCachedMessages = null;
        Set<String> tenantResourceBundleBaseNames = null;
        try {
            this.readLock.lock();
            tenantLoadedResourceBundles = this.getLoadedResourceBundles(tenantDomain);
            loadedBundles = tenantLoadedResourceBundles.get(locale);
            tenantCachedMessages = this.getMessages(tenantDomain);
            props = tenantCachedMessages.get(locale);
            tenantResourceBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain);
            loadedBundleCount = tenantResourceBundleBaseNames.size();
            Object var11_10 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.readLock.unlock();
            throw throwable;
        }
        if (loadedBundles == null) {
            try {
                this.writeLock.lock();
                loadedBundles = new HashSet<String>();
                tenantLoadedResourceBundles.put(locale, loadedBundles);
                init = true;
                Object var13_15 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        if (props == null) {
            try {
                this.writeLock.lock();
                props = new HashMap<String, String>();
                tenantCachedMessages.put(locale, props);
                init = true;
                Object var15_19 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        if (loadedBundles.size() != loadedBundleCount || init) {
            try {
                this.writeLock.lock();
                Set<String> resBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain);
                int count = 0;
                for (String resBundlePath : resBundleBaseNames) {
                    if (loadedBundles.contains(resBundlePath)) continue;
                    ResourceBundle resourcebundle = null;
                    int idx1 = resBundlePath.indexOf("://");
                    if (idx1 != -1) {
                        int idx2 = resBundlePath.indexOf("/", idx1 + 3);
                        String store = resBundlePath.substring(0, idx2);
                        String path = resBundlePath.substring(idx2);
                        StoreRef storeRef = this.tenantService.getName(new StoreRef(store));
                        try {
                            resourcebundle = this.getRepoResourceBundle(storeRef, path, locale);
                        }
                        catch (IOException ioe) {
                            throw new AlfrescoRuntimeException("Failed to read message resource bundle from repository " + resBundlePath + " : " + ioe);
                        }
                    } else {
                        resourcebundle = ResourceBundle.getBundle(resBundlePath, locale);
                    }
                    if (resourcebundle == null) continue;
                    Enumeration<String> enumKeys = resourcebundle.getKeys();
                    while (enumKeys.hasMoreElements()) {
                        String key = enumKeys.nextElement();
                        props.put(key, resourcebundle.getString(key));
                    }
                    loadedBundles.add(resBundlePath);
                    ++count;
                }
                logger.info((Object)("Message bundles (x " + count + ") loaded for locale " + locale));
                Object var22_30 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var22_31 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        return props;
    }

    @Override
    public ResourceBundle getRepoResourceBundle(final StoreRef storeRef, final String path, final Locale locale) throws IOException {
        AuthenticationUtil.RunAsWork<ResourceBundle> getBundleWork = new AuthenticationUtil.RunAsWork<ResourceBundle>(){

            public ResourceBundle doWork() throws Exception {
                NodeRef rootNode = MessageServiceImpl.this.nodeService.getRootNode(storeRef);
                List nodeRefs = MessageServiceImpl.this.searchService.selectNodes(rootNode, path + "_" + locale + MessageServiceImpl.PROPERTIES_FILE_SUFFIX, null, (NamespacePrefixResolver)MessageServiceImpl.this.namespaceService, false);
                if (!(nodeRefs != null && nodeRefs.size() != 0 || (nodeRefs = MessageServiceImpl.this.searchService.selectNodes(rootNode, path + MessageServiceImpl.PROPERTIES_FILE_SUFFIX, null, (NamespacePrefixResolver)MessageServiceImpl.this.namespaceService, false)) != null && nodeRefs.size() != 0)) {
                    logger.debug((Object)("Could not find message resource bundle " + storeRef + "/" + path));
                    return null;
                }
                if (nodeRefs.size() > 1) {
                    throw new RuntimeException("Found more than one message resource bundle " + storeRef + path);
                }
                NodeRef messageResourceNodeRef = (NodeRef)nodeRefs.get(0);
                ContentReader cr = MessageServiceImpl.this.contentService.getReader(messageResourceNodeRef, ContentModel.PROP_CONTENT);
                MessagePropertyResourceBundle resBundle = new MessagePropertyResourceBundle(new InputStreamReader(cr.getContentInputStream(), cr.getEncoding()));
                return resBundle;
            }
        };
        return (ResourceBundle)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getBundleWork, (String)AuthenticationUtil.getSystemUserName());
    }

    public void onEnableTenant() {
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        String tenantDomain = this.getTenantDomain();
        this.putResourceBundleBaseNames(tenantDomain, new HashSet<String>());
        this.putLoadedResourceBundles(tenantDomain, new HashMap<Locale, Set<String>>());
        this.putMessages(tenantDomain, new HashMap<Locale, Map<String, String>>());
        logger.info((Object)"Empty message service initialised");
    }

    public void destroy() {
        String tenantDomain = this.getTenantDomain();
        this.removeLoadedResourceBundles(tenantDomain);
        this.removeMessages(tenantDomain);
        this.removeResourceBundleBaseNames(tenantDomain);
        logger.info((Object)"Messages cache destroyed (all locales)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredBundles() {
        try {
            this.readLock.lock();
            Set<String> set = this.getResourceBundleBaseNames(this.getTenantDomain());
            Object var3_2 = null;
            this.readLock.unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getResourceBundleBaseNames(String tenantDomain) {
        Set resourceBundleBaseNames = (Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain));
        if (resourceBundleBaseNames == null) {
            try {
                this.readLock.unlock();
                this.writeLock.lock();
                this.reset(tenantDomain);
                resourceBundleBaseNames = (Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain));
                Object var4_3 = null;
                this.readLock.lock();
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.readLock.lock();
                this.writeLock.unlock();
                throw throwable;
            }
            if (resourceBundleBaseNames == null) {
                throw new AlfrescoRuntimeException("Failed to re-initialise resourceBundleBaseNamesCache " + tenantDomain);
            }
        }
        return resourceBundleBaseNames;
    }

    private void putResourceBundleBaseNames(String tenantDomain, Set<String> resourceBundleBaseNames) {
        this.resourceBundleBaseNamesCache.put((Serializable)((Object)tenantDomain), resourceBundleBaseNames);
    }

    private void removeResourceBundleBaseNames(String tenantDomain) {
        if (this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain)) != null) {
            ((Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain))).clear();
            this.resourceBundleBaseNamesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Locale, Set<String>> getLoadedResourceBundles(String tenantDomain) {
        Map loadedResourceBundles = (Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain));
        if (loadedResourceBundles == null) {
            try {
                this.readLock.unlock();
                this.writeLock.lock();
                this.reset(tenantDomain);
                loadedResourceBundles = (Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain));
                Object var4_3 = null;
                this.readLock.lock();
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.readLock.lock();
                this.writeLock.unlock();
                throw throwable;
            }
            if (loadedResourceBundles == null) {
                throw new AlfrescoRuntimeException("Failed to re-initialise loadedResourceBundlesCache " + tenantDomain);
            }
        }
        return loadedResourceBundles;
    }

    private void putLoadedResourceBundles(String tenantDomain, Map<Locale, Set<String>> loadedResourceBundles) {
        this.loadedResourceBundlesCache.put((Serializable)((Object)tenantDomain), loadedResourceBundles);
    }

    private void removeLoadedResourceBundles(String tenantDomain) {
        if (this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain)) != null) {
            ((Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain))).clear();
            this.loadedResourceBundlesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    private void clearLoadedResourceBundles(String tenantDomain) {
        if (this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain)) != null) {
            ((Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain))).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Locale, Map<String, String>> getMessages(String tenantDomain) {
        Map messages = (Map)this.messagesCache.get((Serializable)((Object)tenantDomain));
        if (messages == null) {
            try {
                this.readLock.unlock();
                this.writeLock.lock();
                this.reset(tenantDomain);
                messages = (Map)this.messagesCache.get((Serializable)((Object)tenantDomain));
                Object var4_3 = null;
                this.readLock.lock();
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.readLock.lock();
                this.writeLock.unlock();
                throw throwable;
            }
            if (messages == null) {
                throw new AlfrescoRuntimeException("Failed to re-initialise messagesCache " + tenantDomain);
            }
        }
        return messages;
    }

    private void putMessages(String tenantDomain, Map<Locale, Map<String, String>> messages) {
        this.messagesCache.put((Serializable)((Object)tenantDomain), messages);
    }

    private void removeMessages(String tenantDomain) {
        if (this.messagesCache.get((Serializable)((Object)tenantDomain)) != null) {
            ((Map)this.messagesCache.get((Serializable)((Object)tenantDomain))).clear();
            this.messagesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    private String getTenantDomain() {
        return this.tenantService.getCurrentUserDomain();
    }

    @Override
    public void register(MessageDeployer messageDeployer) {
        if (!this.messageDeployers.contains(messageDeployer)) {
            this.messageDeployers.add(messageDeployer);
        }
    }

    public void reset() {
        this.reset(this.getTenantDomain());
    }

    private void reset(String tenantDomain) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting messages ...");
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                MessageServiceImpl.this.destroy();
                MessageServiceImpl.this.init();
                for (MessageDeployer messageDeployer : MessageServiceImpl.this.messageDeployers) {
                    messageDeployer.initMessages();
                }
                return null;
            }
        }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"... resetting messages completed");
        }
    }

    @Override
    public String getBaseBundleName(String resourceName) {
        String bundleBaseName = resourceName;
        int idx = resourceName.indexOf("_");
        if (idx > 0) {
            bundleBaseName = resourceName.substring(0, idx);
        } else {
            int idx1 = resourceName.indexOf(".");
            if (idx1 > 0) {
                bundleBaseName = resourceName.substring(0, idx1);
            }
        }
        return bundleBaseName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagePropertyResourceBundle
    extends ResourceBundle {
        private Properties properties = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessagePropertyResourceBundle(Reader reader) throws IOException {
            try {
                BufferedReader br = new BufferedReader(reader);
                String line = br.readLine();
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        String[] splits = line.split("=", 2);
                        if (splits.length == 2) {
                            this.properties.put(splits[0], splits[1]);
                        } else if (splits.length == 1) {
                            this.properties.put(splits[0], "");
                        } else {
                            logger.warn((Object)("Unexpected message properties file format: " + line));
                            throw new AlfrescoRuntimeException("Unexpected message properties file format: " + line);
                        }
                    }
                    line = br.readLine();
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
        }

        @Override
        public Enumeration<String> getKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            Enumeration<Object> enums = this.properties.keys();
            while (enums.hasMoreElements()) {
                keys.add((String)enums.nextElement());
            }
            return new StringIteratorEnumeration(keys.iterator());
        }

        @Override
        protected Object handleGetObject(String arg0) {
            return this.properties.get(arg0);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class StringIteratorEnumeration
        implements Enumeration<String> {
            private Iterator<String> enums;

            public StringIteratorEnumeration(Iterator<String> enums) {
                this.enums = enums;
            }

            @Override
            public boolean hasMoreElements() {
                return this.enums.hasNext();
            }

            @Override
            public String nextElement() {
                return this.enums.next();
            }
        }
    }
}

