/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoImapUserManager
extends UserManager {
    private Log logger = LogFactory.getLog(AlfrescoImapUserManager.class);
    protected Map<String, GreenMailUser> userMap = Collections.synchronizedMap(new HashMap());
    protected AuthenticationService authenticationService;
    protected PersonService personService;
    protected NodeService nodeService;

    public AlfrescoImapUserManager() {
        super(null);
    }

    public GreenMailUser createUser(String email, String login, String password) throws UserException {
        AlfrescoImapUser user = new AlfrescoImapUser(email, login, password);
        user.create();
        this.addUser(user);
        return user;
    }

    protected void addUser(GreenMailUser user) {
        this.userMap.put(user.getLogin(), user);
    }

    public GreenMailUser getUser(String login) {
        return this.userMap.get(login);
    }

    public GreenMailUser getUserByEmail(String email) {
        GreenMailUser ret = this.getUser(email);
        if (null == ret) {
            for (GreenMailUser user : this.userMap.values()) {
                if (!user.getEmail().trim().equalsIgnoreCase(email.trim())) continue;
                return user;
            }
        }
        return ret;
    }

    public void deleteUser(GreenMailUser user) throws UserException {
        if ((user = this.userMap.remove(user.getLogin())) != null) {
            user.delete();
        }
    }

    public boolean test(String userid, String password) {
        try {
            this.authenticationService.authenticate(userid, password.toCharArray());
            String email = null;
            if (this.personService.personExists(userid)) {
                NodeRef personNodeRef = this.personService.getPerson(userid);
                email = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL));
            }
            AlfrescoImapUser user = new AlfrescoImapUser(email, userid, password);
            this.addUser(user);
        }
        catch (AuthenticationException ex) {
            this.logger.error((Object)("IMAP authentication failed for userid: " + userid));
            return false;
        }
        return true;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

