/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import org.alfresco.model.ImapModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;

public class ImapContentPolicy {
    private ActionService actionService;
    private PolicyComponent policyComponent;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.getActionService());
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.getPolicyComponent());
        this.getPolicyComponent().bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ImapModel.ASPECT_IMAP_CONTENT, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        Action action;
        if (aspectTypeQName.equals((Object)ImapModel.ASPECT_IMAP_CONTENT) && (action = this.getActionService().createAction("extract-metadata")) != null) {
            this.getActionService().executeAction(action, nodeRef);
        }
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public ActionService getActionService() {
        return this.actionService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }
}

