/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import org.alfresco.repo.invitation.site.InviteHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class CancelInviteAction
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 776961141883350908L;
    private MutableAuthenticationDao mutableAuthenticationDao;
    private PersonService personService;
    private WorkflowService workflowService;
    private SiteService siteService;
    private final String MSG_NOT_SITE_MANAGER = "invitation.cancel.not_site_manager";

    protected void initialiseHandler(BeanFactory factory) {
        ServiceRegistry services = (ServiceRegistry)factory.getBean("ServiceRegistry");
        this.mutableAuthenticationDao = (MutableAuthenticationDao)factory.getBean("authenticationDao");
        this.personService = services.getPersonService();
        this.workflowService = services.getWorkflowService();
        this.siteService = services.getSiteService();
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        String inviteeUserName = (String)executionContext.getVariable("inwf_inviteeUserName");
        String siteShortName = (String)executionContext.getVariable("inwf_resourceName");
        String inviteId = (String)executionContext.getVariable("workflowinstanceid");
        String currentUserName = AuthenticationUtil.getFullyAuthenticatedUser();
        String currentUserSiteRole = this.siteService.getMembersRole(siteShortName, currentUserName);
        if (currentUserSiteRole == null || !currentUserSiteRole.equals("SiteManager")) {
            Object[] args = new Object[]{currentUserName, inviteId, siteShortName};
            throw new InvitationExceptionForbidden("invitation.cancel.not_site_manager", args);
        }
        InviteHelper.cleanUpStaleInviteeResources(inviteeUserName, this.mutableAuthenticationDao, this.personService, this.workflowService);
    }
}

