/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jgroups;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.repo.jgroups.AlfrescoJGroupsChannelFactory;
import org.jgroups.Channel;
import org.jgroups.Message;

public class AlfrescoJGroupsChannelFactoryTest
extends TestCase {
    private static byte[] bytes = new byte[65536];
    private String appRegion;

    protected void setUp() throws Exception {
        this.appRegion = this.getName();
    }

    private void stressChannel(Channel channel) throws Exception {
        System.out.println("Test: " + this.getName());
        System.out.println("    Channel: " + channel);
        System.out.println("    Cluster: " + channel.getClusterName());
        channel.send(null, null, (Serializable)Boolean.TRUE);
        channel.send(new Message(null, null, bytes));
    }

    public void testNoCluster() throws Exception {
        Channel channel = AlfrescoJGroupsChannelFactory.getChannel(this.appRegion);
        this.stressChannel(channel);
    }

    public void testBasicCluster() throws Exception {
        AlfrescoJGroupsChannelFactory.changeClusterNamePrefix("blah");
        AlfrescoJGroupsChannelFactory.rebuildChannels();
        Channel channel = AlfrescoJGroupsChannelFactory.getChannel(this.appRegion);
        this.stressChannel(channel);
    }

    public void testHotSwapCluster() throws Exception {
        AlfrescoJGroupsChannelFactory.changeClusterNamePrefix("ONE");
        AlfrescoJGroupsChannelFactory.rebuildChannels();
        Channel channel1 = AlfrescoJGroupsChannelFactory.getChannel(this.appRegion);
        this.stressChannel(channel1);
        AlfrescoJGroupsChannelFactory.changeClusterNamePrefix("TWO");
        AlfrescoJGroupsChannelFactory.rebuildChannels();
        Channel channel2 = AlfrescoJGroupsChannelFactory.getChannel(this.appRegion);
        this.stressChannel(channel1);
        AlfrescoJGroupsChannelFactoryTest.assertTrue((String)"Channel reference must be the same", (channel1 == channel2 ? 1 : 0) != 0);
    }

    static {
        for (int i = 0; i < bytes.length; ++i) {
            AlfrescoJGroupsChannelFactoryTest.bytes[i] = 1;
        }
    }
}

