/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.ValueDerivingMapFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class People
extends BaseScopableProcessorExtension
implements InitializingBean {
    private static Log logger = LogFactory.getLog(People.class);
    private ServiceRegistry services;
    private AuthorityDAO authorityDAO;
    private AuthorityService authorityService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private ContentUsageService contentUsageService;
    private TenantService tenantService;
    private UserNameGenerator usernameGenerator;
    private UserRegistrySynchronizer userRegistrySynchronizer;
    private StoreRef storeRef;
    private ValueDerivingMapFactory<ScriptNode, String, Boolean> valueDerivingMapFactory;
    private int numRetries = 10;

    public void afterPropertiesSet() throws Exception {
        HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>> capabilityTesters = new HashMap<String, ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>>(5);
        capabilityTesters.put("isAdmin", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isAdmin(source);
            }
        });
        capabilityTesters.put("isGuest", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                return People.this.isGuest(source);
            }
        });
        capabilityTesters.put("isMutable", new ValueDerivingMapFactory.ValueDeriver<ScriptNode, Boolean>(){

            @Override
            public Boolean deriveValue(ScriptNode source) {
                String sourceUser = (String)source.getProperties().get(ContentModel.PROP_USERNAME);
                if (!People.this.authenticationService.isAuthenticationMutable(sourceUser)) {
                    return false;
                }
                String currentUser = People.this.authenticationService.getCurrentUserName();
                if (currentUser.equals(sourceUser) || People.this.authorityService.isAdminAuthority(currentUser)) {
                    return true;
                }
                return false;
            }
        });
        this.valueDerivingMapFactory = new ValueDerivingMapFactory(capabilityTesters);
    }

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setUserNameGenerator(UserNameGenerator userNameGenerator) {
        this.usernameGenerator = userNameGenerator;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public void deletePerson(String username) {
        this.personService.deletePerson(username);
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress, String password, boolean setAccountEnabled) {
        ParameterCheck.mandatory((String)"firstName", (Object)firstName);
        ParameterCheck.mandatory((String)"lastName", (Object)lastName);
        ParameterCheck.mandatory((String)"emailAddress", (Object)emailAddress);
        ScriptNode person = null;
        if (userName == null) {
            for (int i = 0; i < this.numRetries && this.personService.personExists(userName = this.usernameGenerator.generateUserName(firstName, lastName, emailAddress, i)); ++i) {
            }
        }
        if (userName != null) {
            String currentDomain;
            if (this.tenantService.isEnabled() && !(currentDomain = this.tenantService.getCurrentUserDomain()).equals("")) {
                if (!this.tenantService.isTenantUser(userName)) {
                    userName = this.tenantService.getDomainUser(userName, currentDomain);
                    logger.warn((Object)("Added domain to username: " + userName));
                } else {
                    try {
                        this.tenantService.checkDomainUser(userName);
                    }
                    catch (RuntimeException re) {
                        throw new AuthenticationException("User must belong to same domain as admin: " + currentDomain);
                    }
                }
            }
            if ((person = this.createPerson(userName, firstName, lastName, emailAddress)) != null && password != null) {
                this.authenticationService.createAuthentication(userName, password.toCharArray());
                this.authenticationService.setAuthenticationEnabled(userName, setAccountEnabled);
                person.save();
            }
        }
        return person;
    }

    public void enableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, true);
        }
    }

    public void disableAccount(String userName) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.authenticationService.setAuthenticationEnabled(userName, false);
        }
    }

    public boolean isAccountEnabled(String userName) {
        return this.authenticationService.getAuthenticationEnabled(userName);
    }

    public void changePassword(String oldPassword, String newPassword) {
        ParameterCheck.mandatoryString((String)"oldPassword", (String)oldPassword);
        ParameterCheck.mandatoryString((String)"newPassword", (String)newPassword);
        this.services.getAuthenticationService().updateAuthentication(AuthenticationUtil.getFullyAuthenticatedUser(), oldPassword.toCharArray(), newPassword.toCharArray());
    }

    public void setPassword(String userName, String password) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"password", (String)password);
        MutableAuthenticationService authService = this.services.getAuthenticationService();
        if (this.authorityService.hasAdminAuthority() && !userName.equalsIgnoreCase(authService.getCurrentUserName())) {
            authService.setAuthentication(userName, password.toCharArray());
        }
    }

    public ScriptNode createPerson(String userName) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public ScriptNode createPerson(String userName, String firstName, String lastName, String emailAddress) {
        ParameterCheck.mandatoryString((String)"userName", (String)userName);
        ParameterCheck.mandatoryString((String)"firstName", (String)firstName);
        ParameterCheck.mandatoryString((String)"lastName", (String)lastName);
        ParameterCheck.mandatoryString((String)"emailAddress", (String)emailAddress);
        ScriptNode person = null;
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_USERNAME, userName);
        properties.put(ContentModel.PROP_FIRSTNAME, firstName);
        properties.put(ContentModel.PROP_LASTNAME, lastName);
        properties.put(ContentModel.PROP_EMAIL, emailAddress);
        if (!this.personService.personExists(userName)) {
            NodeRef personRef = this.personService.createPerson(properties);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public void setQuota(ScriptNode person, String quota) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            this.contentUsageService.setUserQuota((String)person.getProperties().get(ContentModel.PROP_USERNAME), Long.parseLong(quota));
        }
    }

    public Scriptable getPeople(String filter) {
        return this.getPeople(filter, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Scriptable getPeople(String filter, int maxResults) {
        Object[] people;
        block24: {
            people = null;
            if (filter == null || filter.length() == 0) {
                people = this.personService.getAllPeople().toArray();
                if (maxResults > 0 && people.length > maxResults) {
                    Object[] dest = new Object[maxResults];
                    System.arraycopy(people, 0, dest, 0, maxResults);
                    people = dest;
                }
            } else if ((filter = filter.trim()).length() != 0) {
                SearchParameters params = new SearchParameters();
                StringBuilder query = new StringBuilder(256);
                query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" AND (");
                String term = filter.replace("\\", "").replace("\"", "");
                StringTokenizer t = new StringTokenizer(term, " ");
                if (t.countTokens() == 1) {
                    int propIndex = term.indexOf(58);
                    if (propIndex == -1) {
                        query.append("firstName:\"");
                        query.append(term);
                        query.append("*\" lastName:\"");
                        query.append(term);
                        query.append("*\" userName:\"");
                        query.append(term);
                        query.append("*\"");
                    } else {
                        query.append(term.substring(0, propIndex + 1)).append('\"').append(term.substring(propIndex + 1)).append('\"');
                    }
                } else {
                    int nonFtsTokens = 0;
                    while (t.hasMoreTokens()) {
                        if (t.nextToken().indexOf(58) != -1) continue;
                        ++nonFtsTokens;
                    }
                    t = new StringTokenizer(term, " ");
                    params.setDefaultOperator(SearchParameters.Operator.AND);
                    boolean firstToken = true;
                    boolean tokenSurname = false;
                    boolean propertySearch = false;
                    while (t.hasMoreTokens()) {
                        term = t.nextToken();
                        if (!propertySearch && term.indexOf(58) == -1) {
                            if (nonFtsTokens == 1) {
                                query.append("(firstName:\"");
                                query.append(term);
                                query.append("*\" OR lastName:\"");
                                query.append(term);
                                query.append("*\" OR userName:\"");
                                query.append(term);
                                query.append("*\") ");
                                continue;
                            }
                            if (firstToken) {
                                query.append("firstName:\"");
                                query.append(term);
                                query.append("*\" ");
                                firstToken = false;
                                continue;
                            }
                            if (tokenSurname) {
                                query.append("OR ");
                            }
                            query.append("lastName:\"");
                            query.append(term);
                            query.append("*\" ");
                            tokenSurname = true;
                            continue;
                        }
                        int propIndex = term.indexOf(58);
                        query.append(term.substring(0, propIndex + 1)).append('\"').append(term.substring(propIndex + 1)).append('\"');
                        propertySearch = true;
                    }
                }
                query.append(")");
                params.setLanguage("fts-alfresco");
                params.addStore(this.storeRef);
                params.setQuery(query.toString());
                if (maxResults > 0) {
                    params.setLimitBy(LimitBy.FINAL_SIZE);
                    params.setLimit(maxResults);
                }
                ResultSet results = null;
                try {
                    try {
                        results = this.services.getSearchService().query(params);
                        people = results.getNodeRefs().toArray();
                    }
                    catch (Throwable err) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to execute people search: " + query.toString()), err);
                        }
                        Object var14_17 = null;
                        if (results != null) {
                            results.close();
                        }
                        break block24;
                    }
                    Object var14_16 = null;
                    if (results == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    if (results != null) {
                        results.close();
                    }
                    throw throwable;
                }
                results.close();
            }
        }
        if (people == null) {
            people = new Object[]{};
        }
        return Context.getCurrentContext().newArray(this.getScope(), people);
    }

    public ScriptNode getPerson(String username) {
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        ScriptNode person = null;
        if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username);
            person = new ScriptNode(personRef, this.services, this.getScope());
        }
        return person;
    }

    public ScriptNode getGroup(String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        NodeRef groupRef = this.authorityDAO.getAuthorityNodeRefOrNull(groupName);
        if (groupRef != null) {
            group = new ScriptNode(groupRef, this.services, this.getScope());
        }
        return group;
    }

    public void deleteGroup(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        if (group.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)group.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            this.authorityService.deleteAuthority(groupName);
        }
    }

    public ScriptNode createGroup(String groupName) {
        return this.createGroup(null, groupName);
    }

    public ScriptNode createGroup(ScriptNode parentGroup, String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        ScriptNode group = null;
        String actualName = this.services.getAuthorityService().getName(AuthorityType.GROUP, groupName);
        if (!this.authorityService.authorityExists(actualName)) {
            String parentGroupName;
            String result = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            if (parentGroup != null && (parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME)) != null) {
                this.authorityService.addAuthority(parentGroupName, actualName);
            }
            group = this.getGroup(result);
        }
        return group;
    }

    public void addAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.addAuthority(parentGroupName, authorityName);
        }
    }

    public void removeAuthority(ScriptNode parentGroup, ScriptNode authority) {
        ParameterCheck.mandatory((String)"Authority", (Object)authority);
        ParameterCheck.mandatory((String)"ParentGroup", (Object)parentGroup);
        if (parentGroup.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String parentGroupName = (String)parentGroup.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            String authorityName = authority.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER) ? (String)authority.getProperties().get(ContentModel.PROP_AUTHORITY_NAME) : (String)authority.getProperties().get(ContentModel.PROP_USERNAME);
            this.authorityService.removeAuthority(parentGroupName, authorityName);
        }
    }

    public Scriptable getMembers(ScriptNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, true);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getMembers(ScriptNode group, boolean recurse) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        Object[] members = this.getContainedAuthorities(group, AuthorityType.USER, recurse);
        return Context.getCurrentContext().newArray(this.getScope(), members);
    }

    public Scriptable getContainerGroups(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        Object[] parents = null;
        Set<String> authorities = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, (String)person.getProperties().get(ContentModel.PROP_USERNAME), false);
        parents = new Object[authorities.size()];
        int i = 0;
        for (String authority : authorities) {
            ScriptNode group = this.getGroup(authority);
            if (group == null) continue;
            parents[i++] = group;
        }
        return Context.getCurrentContext().newArray(this.getScope(), parents);
    }

    public boolean isAdmin(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isAdminAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public boolean isGuest(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isGuestAuthority((String)person.getProperties().get(ContentModel.PROP_USERNAME));
    }

    public Map<String, Boolean> getCapabilities(ScriptNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        ScriptableHashMap<String, Boolean> retVal = new ScriptableHashMap<String, Boolean>();
        retVal.putAll(this.valueDerivingMapFactory.getMap(person));
        return retVal;
    }

    public ScriptableHashMap getImmutableProperties(String username) {
        Set<QName> props = this.userRegistrySynchronizer.getPersonMappedProperties(username);
        ScriptableHashMap<String, Boolean> propMap = new ScriptableHashMap<String, Boolean>();
        for (QName prop : props) {
            propMap.put(prop.toString(), Boolean.TRUE);
        }
        return propMap;
    }

    private Object[] getContainedAuthorities(ScriptNode container, AuthorityType type, boolean recurse) {
        Object[] members = null;
        if (container.getQNameType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)container.getProperties().get(ContentModel.PROP_AUTHORITY_NAME);
            Set<String> authorities = this.authorityService.getContainedAuthorities(type, groupName, !recurse);
            members = new Object[authorities.size()];
            int i = 0;
            for (String authority : authorities) {
                ScriptNode person;
                AuthorityType authorityType = AuthorityType.getAuthorityType((String)authority);
                if (authorityType.equals((Object)AuthorityType.GROUP)) {
                    ScriptNode group = this.getGroup(authority);
                    if (group == null) continue;
                    members[i++] = group;
                    continue;
                }
                if (!authorityType.equals((Object)AuthorityType.USER) || (person = this.getPerson(authority)) == null) continue;
                members[i++] = person;
            }
        }
        return members != null ? members : new Object[]{};
    }
}

