/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.processor.ProcessorExtension;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.jscript.NativeMap;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.processor.BaseProcessor;
import org.alfresco.scripts.ScriptException;
import org.alfresco.scripts.ScriptResourceHelper;
import org.alfresco.scripts.ScriptResourceLoader;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptProcessor;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptProcessor
extends BaseProcessor
implements ScriptProcessor,
ScriptResourceLoader,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RhinoScriptProcessor.class);
    private static final String PATH_CLASSPATH = "classpath:";
    private static final WrapFactory wrapFactory = new RhinoWrapFactory();
    private final ValueConverter valueConverter = new ValueConverter();
    private StoreRef storeRef;
    private String storePath;
    private Scriptable secureScope;
    private Scriptable nonSecureScope;
    private boolean compile = true;
    private boolean shareSealedScopes = true;
    private final Map<String, Script> scriptCache = new ConcurrentHashMap<String, Script>(256);

    public void setStoreUrl(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setShareSealedScopes(boolean shareSealedScopes) {
        this.shareSealedScopes = shareSealedScopes;
    }

    @Override
    public void reset() {
        this.scriptCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ScriptLocation location, Map<String, Object> model) {
        try {
            Script script = null;
            String path = location.getPath();
            if (this.compile && location.isCachable()) {
                script = this.scriptCache.get(path);
            }
            if (script == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolving and compiling script path: " + path));
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)location.getInputStream(), (OutputStream)os);
                byte[] bytes = os.toByteArray();
                String source = new String(bytes, "UTF-8");
                source = this.resolveScriptImports(new String(bytes));
                Context cx = Context.enter();
                try {
                    script = cx.compileString(source, path, 1, null);
                    if (this.compile && location.isCachable()) {
                        this.scriptCache.put(path, script);
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    Context.exit();
                    throw throwable;
                }
                Context.exit();
                {
                }
            }
            return this.executeScriptImpl(script, model, location.isSecure());
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + location.toString() + "': " + err.getMessage(), err);
        }
    }

    @Override
    public Object execute(String location, Map<String, Object> model) {
        return this.execute(new ClasspathScriptLocation(location), model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(NodeRef nodeRef, QName contentProp, Map<String, Object> model) {
        try {
            Script script;
            ContentReader cr;
            if (!this.services.getNodeService().exists(nodeRef)) {
                throw new AlfrescoRuntimeException("Script Node does not exist: " + nodeRef);
            }
            if (contentProp == null) {
                contentProp = ContentModel.PROP_CONTENT;
            }
            if ((cr = this.services.getContentService().getReader(nodeRef, contentProp)) == null || !cr.exists()) {
                throw new AlfrescoRuntimeException("Script Node content not found: " + nodeRef);
            }
            Context cx = Context.enter();
            try {
                script = cx.compileString(this.resolveScriptImports(cr.getContentString()), nodeRef.toString(), 1, null);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return this.executeScriptImpl(script, model, false);
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute script '" + nodeRef.toString() + "': " + err.getMessage(), err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeString(String source, Map<String, Object> model) {
        try {
            Script script;
            Context cx = Context.enter();
            try {
                script = cx.compileString(this.resolveScriptImports(source), "AlfrescoJS", 1, null);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return this.executeScriptImpl(script, model, true);
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to execute supplied script: " + err.getMessage(), err);
        }
    }

    private String resolveScriptImports(String script) {
        return ScriptResourceHelper.resolveScriptImports((String)script, (ScriptResourceLoader)this, (Log)logger);
    }

    public String loadScriptResource(String resource) {
        NodeRef scriptRef;
        String result = null;
        if (resource.startsWith(PATH_CLASSPATH)) {
            try {
                String scriptClasspath = resource.substring(PATH_CLASSPATH.length());
                InputStream stream = this.getClass().getClassLoader().getResource(scriptClasspath).openStream();
                if (stream == null) {
                    throw new AlfrescoRuntimeException("Unable to load included script classpath resource: " + resource);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)stream, (OutputStream)os);
                byte[] bytes = os.toByteArray();
                result = new String(bytes, "UTF-8");
            }
            catch (IOException err) {
                throw new AlfrescoRuntimeException("Unable to load included script classpath resource: " + resource);
            }
        }
        if (resource.startsWith("/")) {
            NodeRef rootNodeRef = this.services.getNodeService().getRootNode(this.storeRef);
            List nodes = this.services.getSearchService().selectNodes(rootNodeRef, this.storePath, null, (NamespacePrefixResolver)this.services.getNamespaceService(), false);
            if (nodes.size() == 0) {
                throw new AlfrescoRuntimeException("Unable to find store path: " + this.storePath);
            }
            StringTokenizer tokenizer = new StringTokenizer(resource, "/");
            ArrayList<String> elements = new ArrayList<String>(6);
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                elements.add(tokenizer.nextToken());
            }
            try {
                FileInfo fileInfo = this.services.getFileFolderService().resolveNamePath((NodeRef)nodes.get(0), elements);
                scriptRef = fileInfo.getNodeRef();
            }
            catch (FileNotFoundException err) {
                throw new AlfrescoRuntimeException("Unable to load included script repository resource: " + resource);
            }
        } else {
            scriptRef = new NodeRef(resource);
        }
        try {
            ContentReader cr = this.services.getContentService().getReader(scriptRef, ContentModel.PROP_CONTENT);
            if (cr == null || !cr.exists()) {
                throw new AlfrescoRuntimeException("Included Script Node content not found: " + resource);
            }
            result = cr.getContentString();
        }
        catch (ContentIOException err) {
            throw new AlfrescoRuntimeException("Unable to load included script repository resource: " + resource);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeScriptImpl(Script script, Map<String, Object> model, boolean secure) throws AlfrescoRuntimeException {
        Object object;
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.nanoTime();
        }
        model = this.convertToRhinoModel(model);
        Context cx = Context.enter();
        try {
            try {
                Scriptable scope;
                cx.setWrapFactory(wrapFactory);
                if (this.shareSealedScopes) {
                    Scriptable sharedScope = secure ? this.nonSecureScope : this.secureScope;
                    scope = cx.newObject(sharedScope);
                    scope.setPrototype(sharedScope);
                    scope.setParentScope(null);
                } else {
                    scope = this.initScope(cx, secure, false);
                }
                if (model == null) {
                    model = new HashMap<String, Object>();
                }
                for (ProcessorExtension ex : this.processorExtensions.values()) {
                    model.put(ex.getExtensionName(), ex);
                }
                for (String key : model.keySet()) {
                    Object obj = model.get(key);
                    if (obj instanceof Scopeable) {
                        ((Scopeable)obj).setScope(scope);
                    }
                    Object jsObject = Context.javaToJS((Object)obj, (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)key, (Object)jsObject);
                }
                Object result = script.exec(cx, scope);
                object = this.valueConverter.convertValueForJava(result);
                Object var13_14 = null;
            }
            catch (WrappedException w) {
                Throwable err = w.getWrappedException();
                if (!(err instanceof RuntimeException)) throw new AlfrescoRuntimeException(err.getMessage(), err);
                throw (RuntimeException)err;
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException(err.getMessage(), err);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            Context.exit();
            if (!logger.isDebugEnabled()) throw throwable;
            long endTime = System.nanoTime();
            logger.debug((Object)("Time to execute script: " + (float)(endTime - startTime) / 1000000.0f + "ms"));
            throw throwable;
        }
        Context.exit();
        if (!logger.isDebugEnabled()) return object;
        long endTime = System.nanoTime();
        logger.debug((Object)("Time to execute script: " + (float)(endTime - startTime) / 1000000.0f + "ms"));
        return object;
    }

    private Map<String, Object> convertToRhinoModel(Map<String, Object> model) {
        HashMap<String, Object> newModel = null;
        if (model != null) {
            newModel = new HashMap<String, Object>(model.size());
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                if (entry.getValue() instanceof NodeRef) {
                    newModel.put(entry.getKey(), new ScriptNode((NodeRef)entry.getValue(), this.services));
                    continue;
                }
                newModel.put(entry.getKey(), entry.getValue());
            }
        } else {
            newModel = new HashMap(1, 1.0f);
        }
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Context cx = Context.enter();
        try {
            cx.setWrapFactory(wrapFactory);
            this.secureScope = this.initScope(cx, false, true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        cx = Context.enter();
        try {
            cx.setWrapFactory(wrapFactory);
            this.nonSecureScope = this.initScope(cx, true, true);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    protected Scriptable initScope(Context cx, boolean secure, boolean sealed) {
        ScriptableObject scope;
        if (secure) {
            scope = new ImporterTopLevel(cx, sealed);
        } else {
            scope = cx.initStandardObjects(null, sealed);
            scope.delete("Packages");
            scope.delete("getClass");
            scope.delete("java");
        }
        return scope;
    }

    private static class RhinoWrapFactory
    extends WrapFactory {
        private RhinoWrapFactory() {
        }

        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof Map && !(javaObject instanceof ScriptableHashMap)) {
                return new NativeMap(scope, (Map)javaObject);
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
    }
}

