/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.mozilla.javascript.Scriptable;

public final class ScriptVersion
implements Serializable {
    private static final long serialVersionUID = 3896177303419746778L;
    private Scriptable scope;
    private ServiceRegistry services;
    private Version version;
    private static ValueConverter converter = new ValueConverter();

    public ScriptVersion(Version version, ServiceRegistry services, Scriptable scope) {
        this.version = version;
        this.services = services;
        this.scope = scope;
    }

    public Object getCreatedDate() {
        return converter.convertValueForScript(this.services, this.scope, null, this.version.getCreatedDate());
    }

    public String getCreator() {
        return this.version.getCreator();
    }

    public String getLabel() {
        return this.version.getVersionLabel();
    }

    public String getType() {
        return this.version.getVersionType().name();
    }

    public String getDescription() {
        String desc = this.version.getDescription();
        return desc == null ? "" : desc;
    }

    public NodeRef getNodeRef() {
        return this.version.getVersionedNodeRef();
    }

    public ScriptNode getNode() {
        return new ScriptNode(this.version.getFrozenStateNodeRef(), this.services, this.scope);
    }
}

