/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataBean
extends AbstractPropertyBackedBean {
    private final PropertyBackedBean owner;
    private final Class<?> type;
    private final Set<String> propertyNames;
    private final Set<String> writeableProperties;
    private String defaultKeyPrefix;
    private String instanceKeyPrefix;

    public CompositeDataBean(ApplicationContext parent, PropertyBackedBean owner, PropertyBackedBeanRegistry registry, Properties propertyDefaults, String category, Class<?> type, List<String> instancePath) throws IOException {
        this.setApplicationContext(parent);
        this.setRegistry(registry);
        this.setPropertyDefaults(propertyDefaults);
        this.setCategory(category);
        this.setInstancePath(instancePath);
        this.owner = owner;
        this.type = type;
        try {
            PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(type);
            this.propertyNames = new TreeSet<String>();
            this.writeableProperties = new TreeSet<String>();
            for (PropertyDescriptor descriptor : descriptors) {
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || readMethod.getDeclaringClass().isAssignableFrom(Object.class)) continue;
                this.propertyNames.add(descriptor.getName());
                if (descriptor.getWriteMethod() == null) continue;
                this.writeableProperties.add(descriptor.getName());
            }
            this.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        StringBuilder defaultKeyPrefixBuff = new StringBuilder(200);
        StringBuilder instanceKeyPrefixBuff = new StringBuilder(200);
        List<String> id = this.getInstancePath();
        int size = id.size();
        if (size > 1) {
            defaultKeyPrefixBuff.append(id.get(size - 2)).append('.');
            instanceKeyPrefixBuff.append((CharSequence)defaultKeyPrefixBuff);
        }
        defaultKeyPrefixBuff.append("default.");
        instanceKeyPrefixBuff.append("value.").append(id.get(size - 1)).append('.');
        this.defaultKeyPrefix = defaultKeyPrefixBuff.toString();
        this.instanceKeyPrefix = instanceKeyPrefixBuff.toString();
        super.afterPropertiesSet();
    }

    @Override
    protected String resolveDefault(String name) {
        String value = super.resolveDefault(this.instanceKeyPrefix + name);
        return value == null ? super.resolveDefault(this.defaultKeyPrefix + name) : value;
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new CompositeDataBeanState();
    }

    @Override
    public boolean isUpdateable(String name) {
        return this.writeableProperties.contains(name);
    }

    protected Object getBean() {
        return ((CompositeDataBeanState)this.getState(true)).getBean();
    }

    @Override
    protected synchronized void stop(boolean broadcast) {
        super.stop(broadcast);
        if (broadcast) {
            this.owner.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompositeDataBeanState
    implements PropertyBackedBeanState {
        private final Object bean;
        private final BeanWrapper wrappedBean;

        protected CompositeDataBeanState() {
            try {
                this.bean = CompositeDataBean.this.type.newInstance();
                if (this.bean instanceof BeanNameAware) {
                    ((BeanNameAware)this.bean).setBeanName(CompositeDataBean.this.getId().get(CompositeDataBean.this.getId().size() - 1));
                }
                this.wrappedBean = new BeanWrapperImpl(this.bean);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getProperty(String name) {
            Object value = this.wrappedBean.getPropertyValue(name);
            return value == null ? null : value.toString();
        }

        @Override
        public Set<String> getPropertyNames() {
            return CompositeDataBean.this.propertyNames;
        }

        @Override
        public void setProperty(String name, String value) {
            this.wrappedBean.setPropertyValue(name, (Object)value);
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        protected Object getBean() {
            return this.bean;
        }
    }
}

