/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentFilterLanguagesMap
implements ContentFilterLanguagesService {
    private static final String CONFIG_AREA = "content-filter-lang";
    private static final String CONFIG_CONDITION = "Languages Filter Map";
    private static final String USED_STANDARD_CONFIG_CONDITION = "Standard In Use";
    private static final String USED_STANDARD_ELEMENT = "standard";
    private static final String DEFAULT_LANGUAGE_LIST_STANDARD = "ISO 639-1";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_DEFAULT = "default";
    private static final Log logger = LogFactory.getLog(ContentFilterLanguagesMap.class);
    private ConfigService configService;
    private List<String> orderedLangCodes;
    private Map<String, String> languagesByCode;
    private String defaultLanguage = null;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public List<String> getFilterLanguages() {
        return this.orderedLangCodes;
    }

    @Override
    public List<String> getMissingLanguages(List<String> availableLanguages) {
        if (availableLanguages == null || availableLanguages.size() == 0) {
            return this.orderedLangCodes;
        }
        ArrayList<String> returnList = new ArrayList<String>(this.orderedLangCodes.size() - availableLanguages.size());
        int index = 0;
        for (String lang : this.orderedLangCodes) {
            if (availableLanguages.contains(lang)) continue;
            returnList.add(index, lang);
            ++index;
        }
        return returnList;
    }

    @Override
    public String getLabelByCode(String code) {
        String label = I18NUtil.getMessage((String)("content_filter_lang." + code));
        if (label == null || label.length() == 0) {
            label = this.languagesByCode.get(code);
        }
        if (label == null || label.length() == 0) {
            label = code + " (label not found)";
        }
        return label;
    }

    @Override
    public int getOrderByCode(String code) {
        if (this.orderedLangCodes.contains(code)) {
            return this.orderedLangCodes.indexOf(code);
        }
        throw new AlfrescoRuntimeException("Language code not found : " + code);
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void init() {
        ConfigLookupContext clContext = new ConfigLookupContext(CONFIG_AREA);
        String standard = DEFAULT_LANGUAGE_LIST_STANDARD;
        Config configStandard = this.configService.getConfig((Object)USED_STANDARD_CONFIG_CONDITION, clContext);
        if (configStandard != null && configStandard.getConfigElement(USED_STANDARD_ELEMENT) != null) {
            standard = configStandard.getConfigElement(USED_STANDARD_ELEMENT).getValue();
        } else {
            logger.warn((Object)"No standard configured, use by default : ISO 639-1");
        }
        Config configConditions = this.configService.getConfig((Object)CONFIG_CONDITION, clContext);
        Map configElements = configConditions.getConfigElements();
        ConfigElement configLanguages = null;
        if (configElements.containsKey(standard)) {
            configLanguages = (ConfigElement)configElements.get(standard);
        } else {
            configLanguages = (ConfigElement)configElements.values().iterator().next();
            logger.warn((Object)("Ignoring prefered standard doesn't found, choose : " + configLanguages.getName()));
        }
        List languages = configLanguages.getChildren();
        int listSize = languages.size();
        this.orderedLangCodes = new ArrayList<String>(listSize);
        this.languagesByCode = new HashMap<String, String>(listSize);
        for (ConfigElement langElem : languages) {
            boolean isDefault;
            String code = this.convertToOldISOCode(langElem.getAttribute(ATTR_CODE));
            String value = langElem.getValue();
            String def = langElem.getAttribute(ATTR_DEFAULT);
            this.languagesByCode.put(code, value);
            boolean bl = isDefault = def != null && Boolean.parseBoolean(def);
            if (isDefault) {
                if (this.defaultLanguage != null) {
                    logger.warn((Object)("Content filter default language is not unique: " + code));
                } else {
                    this.defaultLanguage = code;
                }
            }
            if (EqualsHelper.nullSafeEquals((Object)this.defaultLanguage, (Object)code)) {
                this.orderedLangCodes.add(0, code);
                continue;
            }
            this.orderedLangCodes.add(code);
        }
        this.orderedLangCodes = Collections.unmodifiableList(this.orderedLangCodes);
        this.languagesByCode = Collections.unmodifiableMap(this.languagesByCode);
    }

    @Override
    public String convertToOldISOCode(String code) {
        if (code.equalsIgnoreCase("he")) {
            code = "iw";
        } else if (code.equalsIgnoreCase("id")) {
            code = "in";
        } else if (code.equalsIgnoreCase("yi")) {
            code = "ji";
        }
        return code;
    }

    @Override
    public String convertToNewISOCode(String code) {
        if (code.equalsIgnoreCase("iw")) {
            code = "he";
        } else if (code.equalsIgnoreCase("in")) {
            code = "id";
        } else if (code.equalsIgnoreCase("ji")) {
            code = "yi";
        }
        return code;
    }
}

