/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class EmptyTranslationAspect
implements CopyServicePolicies.OnCopyNodePolicy,
ContentServicePolicies.OnContentUpdatePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onContentUpdate"), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void onCopyNode(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        throw new IllegalStateException("It's impossible to copy an empty translation");
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (newContent) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TEMPORARY);
        }
    }

    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return EmptyTranslationAspectCopyBehaviourCallback.INSTANCE;
    }

    private static class EmptyTranslationAspectCopyBehaviourCallback
    extends DoNothingCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new EmptyTranslationAspectCopyBehaviourCallback();

        private EmptyTranslationAspectCopyBehaviourCallback() {
        }

        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            throw new IllegalStateException("Nodes with " + ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION + " may not be copied");
        }
    }
}

