/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilingualContentServiceImpl
implements MultilingualContentService {
    private static final QName QNAME_ASSOC_ML_ROOT = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"multilingualRoot");
    private static Log logger = LogFactory.getLog(MultilingualContentServiceImpl.class);
    private NodeService nodeService;
    private PermissionService permissionService;
    private ContentFilterLanguagesService contentFilterLanguagesService;
    private FileFolderService fileFolderService;
    private VersionService versionService;
    private BehaviourFilter policyBehaviourFilter;
    private static final QName QNAME_ML_CONTAINER = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"mlContainer");
    private static final QName QNAME_ML_TRANSLATION = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"mlTranslation");

    private NodeRef getMLContainerRoot() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List assocRefs = this.nodeService.getChildAssocs(rootNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QNAME_ASSOC_ML_ROOT);
        if (assocRefs.size() != 1) {
            throw new AlfrescoRuntimeException("Unable to find bootstrap location for ML Root using query: " + QNAME_ASSOC_ML_ROOT);
        }
        NodeRef mlRootNodeRef = ((ChildAssociationRef)assocRefs.get(0)).getChildRef();
        return mlRootNodeRef;
    }

    private NodeRef makeMLContainer() {
        NodeRef mlContainerRootNodeRef = this.getMLContainerRoot();
        PropertyMap versionProperties = new PropertyMap();
        ChildAssociationRef assocRef = this.nodeService.createNode(mlContainerRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_ML_CONTAINER, ContentModel.TYPE_MULTILINGUAL_CONTAINER, (Map)versionProperties);
        NodeRef mlContainerNodeRef = assocRef.getChildRef();
        this.nodeService.addAspect(mlContainerNodeRef, ContentModel.ASPECT_VERSIONABLE, (Map)versionProperties);
        this.permissionService.setPermission(mlContainerNodeRef, "GROUP_EVERYONE", "All", true);
        this.permissionService.setPermission(mlContainerNodeRef, AuthenticationUtil.getGuestUserName(), "All", true);
        return mlContainerNodeRef;
    }

    private NodeRef getMLContainer(NodeRef mlDocumentNodeRef, boolean allowNull) {
        NodeRef mlContainerNodeRef = null;
        List parentAssocRefs = this.nodeService.getParentAssocs(mlDocumentNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL);
        if (parentAssocRefs.size() == 0) {
            if (!allowNull) {
                throw new AlfrescoRuntimeException("No multilingual container exists for document node: " + mlDocumentNodeRef);
            }
            mlContainerNodeRef = null;
        } else if (parentAssocRefs.size() >= 1) {
            ChildAssociationRef toKeepAssocRef = (ChildAssociationRef)parentAssocRefs.get(0);
            mlContainerNodeRef = toKeepAssocRef.getParentRef();
        }
        return mlContainerNodeRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeRef getOrCreateMLContainer(NodeRef mlDocumentNodeRef, boolean allowCreate) {
        if (!this.nodeService.hasAspect(mlDocumentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            throw new IllegalArgumentException("Node must have aspect " + ContentModel.ASPECT_MULTILINGUAL_DOCUMENT + " applied");
        }
        NodeRef mlContainerNodeRef = null;
        boolean createAssociation = false;
        List parentAssocRefs = this.nodeService.getParentAssocs(mlDocumentNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL);
        if (parentAssocRefs.size() == 0) {
            if (!allowCreate) throw new AlfrescoRuntimeException("No multilingual container exists for document node: " + mlDocumentNodeRef);
            mlContainerNodeRef = this.makeMLContainer();
            createAssociation = true;
        } else if (parentAssocRefs.size() == 1) {
            ChildAssociationRef toKeepAssocRef = (ChildAssociationRef)parentAssocRefs.get(0);
            mlContainerNodeRef = toKeepAssocRef.getParentRef();
        } else if (parentAssocRefs.size() > 1) {
            logger.warn((Object)("Cleaning up multiple multilingual containers on node: " + mlDocumentNodeRef));
            ChildAssociationRef toKeepAssocRef = (ChildAssociationRef)parentAssocRefs.get(0);
            mlContainerNodeRef = toKeepAssocRef.getParentRef();
            boolean first = true;
            for (ChildAssociationRef assocRef : parentAssocRefs) {
                if (first) {
                    first = false;
                    continue;
                }
                this.nodeService.removeChildAssociation(assocRef);
            }
        }
        if (!createAssociation) return mlContainerNodeRef;
        this.nodeService.addChild(mlContainerNodeRef, mlDocumentNodeRef, ContentModel.ASSOC_MULTILINGUAL_CHILD, QNAME_ML_TRANSLATION);
        return mlContainerNodeRef;
    }

    private NodeRef makeTranslationImpl(NodeRef mlContainerNodeRef, NodeRef contentNodeRef, Locale locale) {
        boolean forceNewVersion = this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_VERSIONABLE);
        if (!this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            PropertyMap properties = new PropertyMap();
            properties.put(ContentModel.PROP_LOCALE, locale);
            this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_LOCALIZED, (Map)properties);
            this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT, null);
        } else {
            this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_LOCALE, (Serializable)locale);
        }
        if (forceNewVersion) {
            this.versionService.createVersion(contentNodeRef, null);
        }
        if (mlContainerNodeRef == null) {
            mlContainerNodeRef = this.getOrCreateMLContainer(contentNodeRef, true);
            Serializable containerFunctionalName = this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_NAME);
            this.nodeService.setProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE, (Serializable)locale);
            this.nodeService.setProperty(mlContainerNodeRef, ContentModel.PROP_NAME, containerFunctionalName);
        } else {
            Map<Locale, NodeRef> existingLanguages;
            QName contentNodeType;
            QName pivotNodeType;
            NodeRef pivotNodeRef = this.getPivotTranslation(mlContainerNodeRef);
            if (pivotNodeRef != null && !pivotNodeRef.equals((Object)contentNodeRef) && !(pivotNodeType = this.nodeService.getType(pivotNodeRef)).equals((Object)(contentNodeType = this.nodeService.getType(contentNodeRef)))) {
                this.nodeService.setType(contentNodeRef, pivotNodeType);
            }
            if ((existingLanguages = this.getTranslations(mlContainerNodeRef)).containsKey(locale)) {
                throw new AlfrescoRuntimeException("Duplicate locale in document pool: " + locale);
            }
            this.nodeService.addChild(mlContainerNodeRef, contentNodeRef, ContentModel.ASSOC_MULTILINGUAL_CHILD, QNAME_ML_TRANSLATION);
        }
        return mlContainerNodeRef;
    }

    private boolean isPivotTranslation(NodeRef contentNodeRef) {
        Locale locale = (Locale)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_LOCALE);
        NodeRef containerNodeRef = this.getOrCreateMLContainer(contentNodeRef, false);
        Locale containerLocale = (Locale)this.nodeService.getProperty(containerNodeRef, ContentModel.PROP_LOCALE);
        boolean isPivot = EqualsHelper.nullSafeEquals((Object)locale, (Object)containerLocale);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node " + (isPivot ? "is" : "is not") + " pivot: " + contentNodeRef));
        }
        return isPivot;
    }

    @Override
    public boolean isTranslation(NodeRef contentNodeRef) {
        if (!this.nodeService.hasAspect(contentNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document is not multilingual: " + contentNodeRef));
            }
            return false;
        }
        Map<Locale, NodeRef> translations = this.getTranslations(contentNodeRef);
        if (translations.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document is a translation: " + contentNodeRef));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document is not a translation: " + contentNodeRef));
        }
        return false;
    }

    @Override
    public void makeTranslation(NodeRef contentNodeRef, Locale locale) {
        NodeRef mlContainerNodeRef = this.makeTranslationImpl(null, contentNodeRef, locale);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Made a translation: \n   content:   " + contentNodeRef + "\n" + "   locale:    " + locale + "\n" + "   container: " + mlContainerNodeRef));
        }
    }

    @Override
    public void deleteTranslationContainer(NodeRef mlContainerNodeRef) {
        if (!ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(mlContainerNodeRef))) {
            throw new IllegalArgumentException("Node type must be " + ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        Map<Locale, NodeRef> translations = this.getTranslations(mlContainerNodeRef);
        int translationCount = translations.size();
        for (NodeRef translationToRemove : translations.values()) {
            this.unmakeTranslationSimple(translationToRemove);
            if (!this.nodeService.exists(translationToRemove)) continue;
            this.nodeService.deleteNode(translationToRemove);
        }
        this.nodeService.deleteNode(mlContainerNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ML container removed: \n   Container:  " + mlContainerNodeRef + "\n" + "   Number of translations: " + translationCount));
        }
    }

    private void unmakeTranslationSimple(NodeRef translationNodeRef) {
        if (this.nodeService.hasAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
            this.nodeService.removeAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
            this.nodeService.addAspect(translationNodeRef, ContentModel.ASPECT_TEMPORARY, null);
        } else {
            this.nodeService.removeAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        }
    }

    @Override
    public void unmakeTranslation(NodeRef translationNodeRef) {
        NodeRef containerNodeRef = this.getMLContainer(translationNodeRef, true);
        if (containerNodeRef == null) {
            this.unmakeTranslationSimple(translationNodeRef);
        } else if (this.isPivotTranslation(translationNodeRef)) {
            List mlChildAssocs = this.nodeService.getChildAssocs(containerNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef mlChildAssoc : mlChildAssocs) {
                NodeRef mlChildNodeRef = mlChildAssoc.getChildRef();
                this.unmakeTranslationSimple(mlChildNodeRef);
            }
            this.nodeService.deleteNode(containerNodeRef);
        } else {
            this.nodeService.removeChild(containerNodeRef, translationNodeRef);
            this.unmakeTranslationSimple(translationNodeRef);
        }
    }

    @Override
    public void addTranslation(NodeRef newTranslationNodeRef, NodeRef translationOfNodeRef, Locale locale) {
        NodeRef mlContainerNodeRef = null;
        mlContainerNodeRef = ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(translationOfNodeRef)) ? translationOfNodeRef : this.getOrCreateMLContainer(translationOfNodeRef, false);
        this.makeTranslationImpl(mlContainerNodeRef, newTranslationNodeRef, locale);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added a translation: \n   Translation of:  " + translationOfNodeRef + "\n" + "   New translation: " + newTranslationNodeRef + "\n" + "   Locale:          " + locale));
        }
    }

    @Override
    public NodeRef getTranslationContainer(NodeRef translationNodeRef) {
        NodeRef mlContainerNodeRef = this.getOrCreateMLContainer(translationNodeRef, false);
        return mlContainerNodeRef;
    }

    @Override
    public Map<Locale, NodeRef> getTranslations(NodeRef translationOfNodeRef) {
        NodeRef mlContainerNodeRef = null;
        QName typeQName = this.nodeService.getType(translationOfNodeRef);
        mlContainerNodeRef = typeQName.equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER) ? translationOfNodeRef : this.getOrCreateMLContainer(translationOfNodeRef, false);
        List assocRefs = this.nodeService.getChildAssocs(mlContainerNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL);
        HashMap<Locale, NodeRef> nodeRefsByLocale = new HashMap<Locale, NodeRef>(13);
        for (ChildAssociationRef assocRef : assocRefs) {
            NodeRef nodeRef = assocRef.getChildRef();
            Locale locale = (Locale)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE);
            nodeRefsByLocale.put(locale, nodeRef);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found all translations: \n   Node: " + translationOfNodeRef + " (type " + typeQName + ")\n" + "   Map: " + nodeRefsByLocale));
        }
        return nodeRefsByLocale;
    }

    @Override
    public NodeRef getTranslationForLocale(NodeRef translationNodeRef, Locale locale) {
        Set<Locale> locales;
        Locale nearestLocale;
        Map<Locale, NodeRef> nodeRefsByLocale = this.getTranslations(translationNodeRef);
        NodeRef nearestNodeRef = nodeRefsByLocale.get(nearestLocale = I18NUtil.getNearestLocale((Locale)locale, locales = nodeRefsByLocale.keySet()));
        if (nearestNodeRef == null && (nearestNodeRef = this.getPivotTranslation(translationNodeRef)) == null) {
            nearestNodeRef = translationNodeRef;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found nearest locale: \n   Given node:   " + translationNodeRef + "\n" + "   Given locale: " + locale + "\n" + "   Found node:   " + nearestNodeRef + "\n" + "   Found locale: " + nearestLocale));
        }
        return nearestNodeRef;
    }

    @Override
    public List<Locale> getMissingTranslations(NodeRef localizedNodeRef, boolean addThisNodeLocale) {
        ArrayList<Locale> foundLocales = new ArrayList<Locale>(this.getTranslations(localizedNodeRef).keySet());
        ArrayList<String> foundLanguages = new ArrayList<String>();
        for (Locale locale : foundLocales) {
            foundLanguages.add(locale.getLanguage());
        }
        if (addThisNodeLocale) {
            Locale localeNode = (Locale)this.nodeService.getProperty(localizedNodeRef, ContentModel.PROP_LOCALE);
            if (localeNode != null) {
                foundLanguages.remove(localeNode.toString());
            } else {
                logger.warn((Object)("No locale found for the node " + localizedNodeRef));
            }
        }
        List<String> missingLanguages = null;
        missingLanguages = foundLanguages.size() == 0 ? this.contentFilterLanguagesService.getFilterLanguages() : this.contentFilterLanguagesService.getMissingLanguages(foundLanguages);
        ArrayList<Locale> missingLocales = new ArrayList<Locale>(missingLanguages.size() + 1);
        for (String lang : missingLanguages) {
            missingLocales.add(I18NUtil.parseLocale((String)lang));
        }
        return missingLocales;
    }

    @Override
    public NodeRef getPivotTranslation(NodeRef nodeRef) {
        Locale containerLocale = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            NodeRef container = this.getTranslationContainer(nodeRef);
            containerLocale = (Locale)this.nodeService.getProperty(container, ContentModel.PROP_LOCALE);
        } else if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(nodeRef))) {
            containerLocale = (Locale)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE);
        } else {
            logger.warn((Object)("The node is not multilingual " + nodeRef));
        }
        Map<Locale, NodeRef> nodeRefsByLocale = this.getTranslations(nodeRef);
        Set<Locale> locales = nodeRefsByLocale.keySet();
        Locale nearestLocale = I18NUtil.getNearestLocale((Locale)containerLocale, locales);
        if (nearestLocale == null) {
            return null;
        }
        return nodeRefsByLocale.get(nearestLocale);
    }

    @Override
    public NodeRef addEmptyTranslation(NodeRef translationOfNodeRef, String name, Locale locale) {
        boolean hasMLAspect = this.nodeService.hasAspect(translationOfNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        boolean isMLContainer = this.nodeService.getType(translationOfNodeRef).equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        if (hasMLAspect || isMLContainer) {
            NodeRef pivotTranslationNodeRef = this.getPivotTranslation(translationOfNodeRef);
            if (pivotTranslationNodeRef != null) {
                translationOfNodeRef = pivotTranslationNodeRef;
            }
        } else {
            throw new IllegalArgumentException("Node must have aspect " + ContentModel.ASPECT_MULTILINGUAL_DOCUMENT + ": \n" + "   Translation: " + translationOfNodeRef + "\n" + "   Locale:      " + locale);
        }
        FileInfo translationOfFileInfo = this.fileFolderService.getFileInfo(translationOfNodeRef);
        String translationOfName = translationOfFileInfo.getName();
        if (name == null) {
            name = translationOfName;
        }
        if (name.equalsIgnoreCase(translationOfName)) {
            String extension;
            String rawName;
            int index;
            String localeStr = locale.toString();
            if (localeStr.endsWith("_")) {
                localeStr = localeStr.substring(0, localeStr.length() - 1);
            }
            if ((index = name.lastIndexOf(46)) > 0) {
                rawName = name.substring(0, index);
                extension = "." + name.substring(index + 1);
            } else {
                rawName = name;
                extension = "";
            }
            name = rawName + "_" + localeStr + extension;
        }
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(translationOfNodeRef).getParentRef();
        QName newTranslationType = this.nodeService.getType(translationOfNodeRef);
        NodeRef newTranslationNodeRef = this.fileFolderService.create(parentNodeRef, name, newTranslationType).getNodeRef();
        this.addTranslation(newTranslationNodeRef, translationOfNodeRef, locale);
        ContentData translationOfContentData = (ContentData)this.nodeService.getProperty(translationOfNodeRef, ContentModel.PROP_CONTENT);
        if (translationOfContentData != null) {
            ContentData newTranslationContentData = new ContentData(null, translationOfContentData.getMimetype(), translationOfContentData.getSize(), translationOfContentData.getEncoding(), translationOfContentData.getLocale());
            this.nodeService.setProperty(newTranslationNodeRef, ContentModel.PROP_CONTENT, (Serializable)newTranslationContentData);
        }
        this.nodeService.addAspect(newTranslationNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION, null);
        this.nodeService.addAspect(newTranslationNodeRef, ContentModel.ASPECT_TEMPORARY, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added an empty translation: \n   Translation of:  " + translationOfNodeRef + "\n" + "   New translation: " + newTranslationNodeRef + "\n" + "   Locale:          " + locale));
        }
        return newTranslationNodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef copyTranslationContainer(NodeRef mlContainerNodeRef, NodeRef newParentRef, String prefixName) throws Exception {
        boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
        if (!ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(mlContainerNodeRef))) {
            throw new IllegalArgumentException("Node type must be " + ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        if (this.nodeService.getChildAssocs(mlContainerNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL).size() < 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MLContainer has no translation " + mlContainerNodeRef));
            }
            return null;
        }
        NodeRef spaceBefore = this.nodeService.getPrimaryParent(this.getPivotTranslation(mlContainerNodeRef)).getParentRef();
        if (spaceBefore.equals((Object)newParentRef)) {
            throw new AlfrescoRuntimeException("Impossible to copy the mlContainer, source folder is the same as the destination container.");
        }
        NodeRef pivotNodeRef = this.getPivotTranslation(mlContainerNodeRef);
        Locale pivotLocale = (Locale)this.nodeService.getProperty(pivotNodeRef, ContentModel.PROP_LOCALE);
        String pivotName = prefixName + (String)((Object)this.nodeService.getProperty(pivotNodeRef, ContentModel.PROP_NAME));
        if (prefixName == null) {
            prefixName = "";
        }
        NodeRef pivotCopyNodeRef = null;
        pivotCopyNodeRef = this.fileFolderService.copy(pivotNodeRef, newParentRef, pivotName).getNodeRef();
        this.makeTranslation(pivotCopyNodeRef, pivotLocale);
        NodeRef newMLContainerNodeRef = this.getMLContainer(pivotCopyNodeRef, false);
        for (Map.Entry<Locale, NodeRef> entry : this.getTranslations(mlContainerNodeRef).entrySet()) {
            NodeRef copyNodeRef;
            Locale translationLocale = entry.getKey();
            NodeRef translationNodeRef = entry.getValue();
            String name = prefixName + (String)((Object)this.nodeService.getProperty(translationNodeRef, ContentModel.PROP_NAME));
            if (translationNodeRef.equals((Object)pivotNodeRef)) continue;
            if (this.nodeService.hasAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                Object var18_17;
                this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
                this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
                try {
                    copyNodeRef = this.fileFolderService.copy(translationNodeRef, newParentRef, name).getNodeRef();
                    this.nodeService.addChild(newMLContainerNodeRef, copyNodeRef, ContentModel.ASSOC_MULTILINGUAL_CHILD, QNAME_ML_TRANSLATION);
                    this.nodeService.addAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT, null);
                    this.nodeService.addAspect(translationNodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION, null);
                    var18_17 = null;
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
                    continue;
                }
                catch (Throwable throwable) {
                    var18_17 = null;
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
                    throw throwable;
                }
            }
            copyNodeRef = this.fileFolderService.copy(translationNodeRef, newParentRef, name).getNodeRef();
            this.addTranslation(copyNodeRef, newMLContainerNodeRef, translationLocale);
            this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_LOCALE, (Serializable)translationLocale);
        }
        MLPropertyInterceptor.setMLAware(wasMLAware);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MLContainer copied: \n   Copy of : " + mlContainerNodeRef + "(translations located in " + spaceBefore + ") \n" + "   Copy :  " + newMLContainerNodeRef + "(translations located in " + newParentRef + ") \n"));
        }
        return newMLContainerNodeRef;
    }

    @Override
    public void moveTranslationContainer(NodeRef mlContainerNodeRef, NodeRef newParentRef) throws FileExistsException, FileNotFoundException {
        if (!ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(mlContainerNodeRef))) {
            throw new IllegalArgumentException("Node type must be " + ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        if (this.nodeService.getChildAssocs(mlContainerNodeRef, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL).size() < 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MLContainer has no translation " + mlContainerNodeRef));
            }
            return;
        }
        NodeRef spaceBefore = this.nodeService.getPrimaryParent(this.getPivotTranslation(mlContainerNodeRef)).getParentRef();
        if (spaceBefore.equals((Object)newParentRef)) {
            return;
        }
        for (NodeRef translationToMove : this.getTranslations(mlContainerNodeRef).values()) {
            this.fileFolderService.move(translationToMove, newParentRef, null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MLContainer moved: \n   Old location of " + mlContainerNodeRef + " : " + spaceBefore + ") \n" + "   New location of " + mlContainerNodeRef + " : " + newParentRef + ")"));
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }
}

