/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.service.cmr.repository.NodeRef;

public class MultilingualDocumentAspectTest
extends AbstractMultilingualTestCases {
    public void testCopy() throws Exception {
        NodeRef original = this.createContent();
        this.multilingualContentService.makeTranslation(original, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(original);
        NodeRef copy = this.fileFolderService.copy(original, this.nodeService.getPrimaryParent(original).getParentRef(), "COPY" + System.currentTimeMillis()).getNodeRef();
        MultilingualDocumentAspectTest.assertFalse((String)"The copy of a mlDocument can't have the multilingual aspect", (boolean)this.nodeService.hasAspect(copy, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
        MultilingualDocumentAspectTest.assertEquals((String)"The copy of a mlDocument can't be a children of the mlContainer", (int)1, (int)this.multilingualContentService.getTranslations(mlContainer).size());
    }

    public void testDeleteNode() throws Exception {
        NodeRef trad1 = this.createContent();
        NodeRef trad2 = this.createContent();
        NodeRef trad3 = this.createContent();
        NodeRef parent = this.nodeService.getPrimaryParent(trad1).getParentRef();
        this.multilingualContentService.makeTranslation(trad1, Locale.FRENCH);
        this.multilingualContentService.addTranslation(trad2, trad1, Locale.GERMAN);
        this.multilingualContentService.addTranslation(trad3, trad1, Locale.ITALIAN);
        this.nodeService.deleteNode(trad3);
        MultilingualDocumentAspectTest.assertEquals((String)"The deleted node must be removed to the space", (int)2, (int)this.nodeService.getChildAssocs(parent).size());
        MultilingualDocumentAspectTest.assertEquals((String)"The deleted node must be removed to the child associations of the mlContainer", (int)2, (int)this.multilingualContentService.getTranslations(trad1).size());
        NodeRef restoredNode = this.nodeArchiveService.restoreArchivedNode(this.nodeArchiveService.getArchivedNode(trad3)).getRestoredNodeRef();
        MultilingualDocumentAspectTest.assertEquals((String)"The restored node must be restaured to the the space", (int)3, (int)this.nodeService.getChildAssocs(parent).size());
        MultilingualDocumentAspectTest.assertEquals((String)"The restored node would not be restaured to the mlContainer", (int)2, (int)this.multilingualContentService.getTranslations(trad1).size());
        MultilingualDocumentAspectTest.assertFalse((String)"The restored node can't keep the multilingual aspect", (boolean)this.nodeService.hasAspect(restoredNode, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
    }

    public void testDeletePivot() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef trans1 = this.createContent();
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(pivot);
        this.multilingualContentService.addTranslation(trans1, pivot, Locale.KOREAN);
        this.nodeService.deleteNode(pivot);
        MultilingualDocumentAspectTest.assertFalse((String)"The pivot would be removed", (boolean)this.nodeService.exists(pivot));
        MultilingualDocumentAspectTest.assertFalse((String)"The mlContainer must be removed if the pivot is removed", (boolean)this.nodeService.exists(mlContainer));
        MultilingualDocumentAspectTest.assertTrue((String)"The last translation would not be removed", (boolean)this.nodeService.exists(trans1));
        MultilingualDocumentAspectTest.assertFalse((String)"The last translation can't keep the multilingual aspect", (boolean)this.nodeService.hasAspect(trans1, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT));
    }

    public void testDeleteLastNode() throws Exception {
        NodeRef pivot = this.createContent();
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(pivot);
        this.nodeService.deleteNode(pivot);
        MultilingualDocumentAspectTest.assertFalse((String)"The mlContainer must be removed if the last translation is removed", (boolean)this.nodeService.exists(mlContainer));
    }

    public void testRemoveAspect() throws Exception {
    }

    public void testUpdateLocale() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef trans1 = this.createContent();
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(pivot);
        this.multilingualContentService.addTranslation(trans1, pivot, Locale.KOREAN);
        Map props = this.nodeService.getProperties(trans1);
        props.put(ContentModel.PROP_LOCALE, Locale.GERMAN);
        this.nodeService.setProperties(trans1, props);
        MultilingualDocumentAspectTest.assertEquals((String)"The locale for the pivot would be changed ", (Object)Locale.GERMAN, (Object)this.nodeService.getProperty(trans1, ContentModel.PROP_LOCALE));
        MultilingualDocumentAspectTest.assertEquals((String)"The pivot reference would not be changed in the mlContainer", (Object)Locale.FRENCH, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
        props = this.nodeService.getProperties(pivot);
        props.put(ContentModel.PROP_LOCALE, Locale.US);
        this.nodeService.setProperties(pivot, props);
        MultilingualDocumentAspectTest.assertEquals((String)"The locale for the pivot would be changed ", (Object)Locale.US, (Object)this.nodeService.getProperty(pivot, ContentModel.PROP_LOCALE));
        MultilingualDocumentAspectTest.assertEquals((String)"The pivot reference would be changes in the mlContainer", (Object)Locale.US, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
    }

    public void testUpdateRedundantLocale() throws Exception {
        NodeRef pivot = this.createContent();
        NodeRef trans1 = this.createContent();
        NodeRef trans2 = this.createContent();
        this.multilingualContentService.makeTranslation(pivot, Locale.FRENCH);
        this.multilingualContentService.addTranslation(trans1, pivot, Locale.KOREAN);
        this.multilingualContentService.addTranslation(trans2, pivot, Locale.JAPANESE);
        Map props = this.nodeService.getProperties(trans2);
        props.put(ContentModel.PROP_LOCALE, Locale.KOREAN);
        boolean exceptionCatched = false;
        try {
            this.nodeService.setProperties(trans2, props);
        }
        catch (Exception ignore) {
            exceptionCatched = true;
        }
        MultilingualDocumentAspectTest.assertTrue((String)"The modification of this locale must catch an exception because it is already in use in another translation", (boolean)exceptionCatched);
        MultilingualDocumentAspectTest.assertEquals((String)"The locale must not be changed", (Object)Locale.JAPANESE, (Object)((Locale)this.nodeService.getProperty(trans2, ContentModel.PROP_LOCALE)));
        props = this.nodeService.getProperties(trans2);
        props.put(ContentModel.PROP_LOCALE, Locale.ITALIAN);
        exceptionCatched = false;
        try {
            this.nodeService.setProperties(trans2, props);
        }
        catch (Exception ignore) {
            exceptionCatched = true;
        }
        MultilingualDocumentAspectTest.assertFalse((String)"The modification of the locale would not throws an exception", (boolean)exceptionCatched);
        MultilingualDocumentAspectTest.assertEquals((String)"The locale must be changed", (Object)Locale.ITALIAN, (Object)((Locale)this.nodeService.getProperty(trans2, ContentModel.PROP_LOCALE)));
    }
}

