/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.Collection;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.module.ImporterModuleComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ComponentsTest
extends TestCase {
    private static ApplicationContext ctx = new ClassPathXmlApplicationContext("module/module-component-test-beans.xml");
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private NodeService nodeService;
    private UserTransaction txn;

    protected void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("AuthenticationComponent");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = this.transactionService.getUserTransaction();
    }

    protected void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.txn.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testSetup() throws Exception {
    }

    private NodeRef getLoadedCategoryRoot() {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        CategoryService categoryService = this.serviceRegistry.getCategoryService();
        Collection<ChildAssociationRef> assocRefs = categoryService.getRootCategories(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
        for (ChildAssociationRef assocRef : assocRefs) {
            NodeRef nodeRef = assocRef.getChildRef();
            if (!nodeRef.getId().equals("test:xyz-root")) continue;
            return nodeRef;
        }
        return null;
    }

    public void testImporterModuleComponent() throws Exception {
        NodeRef nodeRef = this.getLoadedCategoryRoot();
        if (nodeRef != null) {
            CategoryService categoryService = this.serviceRegistry.getCategoryService();
            categoryService.deleteCategory(nodeRef);
        }
        nodeRef = this.getLoadedCategoryRoot();
        ComponentsTest.assertNull((String)"Category not deleted", (Object)nodeRef);
        ImporterModuleComponent component = (ImporterModuleComponent)ctx.getBean("module.test.importerComponent");
        component.execute();
        nodeRef = this.getLoadedCategoryRoot();
        ComponentsTest.assertNotNull((String)"Loaded category root not found", (Object)nodeRef);
    }
}

