/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggerModuleComponent
extends AbstractModuleComponent {
    private LogLevel logLevel = LogLevel.INFO;
    private String message;

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.valueOf(logLevel);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"message", (Object)this.message);
        super.checkProperties();
    }

    protected void executeInternal() throws Throwable {
        String moduleId = super.getModuleId();
        String name = super.getName();
        Log logger = LogFactory.getLog((String)(moduleId + "." + name));
        switch (this.logLevel) {
            case INFO: {
                logger.info((Object)this.message);
                break;
            }
            case WARN: {
                logger.warn((Object)this.message);
                break;
            }
            case ERROR: {
                logger.error((Object)this.message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogLevel {
        INFO,
        WARN,
        ERROR;

    }
}

