/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.service.cmr.module.ModuleDetails;

public class ModuleDetailsHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleDetails createModuleDetailsFromPropertiesStream(InputStream is) throws IOException {
        ModuleDetailsImpl moduleDetailsImpl;
        try {
            Properties properties = new Properties();
            properties.load(is);
            moduleDetailsImpl = new ModuleDetailsImpl(properties);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                is.close();
            }
            catch (Throwable e) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        return moduleDetailsImpl;
    }

    public static ModuleDetails createModuleDetailsFromPropertyLocation(String location) {
        ModuleDetails result = null;
        try {
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(location, ModuleManagementTool.DETECTOR_AMP_AND_WAR);
            if (file.exists()) {
                FileInputStream is = new FileInputStream((File)file);
                result = ModuleDetailsHelper.createModuleDetailsFromPropertiesStream((InputStream)is);
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load module details from property file.", exception);
        }
        return result;
    }

    public static ModuleDetails createModuleDetailsFromWarAndId(String warLocation, String moduleId) {
        String modulePropertiesFileLocation = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
        return ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(modulePropertiesFileLocation);
    }

    public static de.schlichtherle.io.File getModuleDetailsFileFromWarAndId(String warLocation, String moduleId) {
        String location = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(location, ModuleManagementTool.DETECTOR_AMP_AND_WAR);
        return file;
    }

    public static String getModulePropertiesFileLocation(String warLocation, String moduleId) {
        return warLocation + ModuleDetailsHelper.getModulePropertiesFilePathInWar(moduleId);
    }

    public static String getModulePropertiesFilePathInWar(String moduleId) {
        return "/WEB-INF/classes/alfresco/module/" + moduleId + "/" + "module.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModuleDetails(String warLocation, ModuleDetails moduleDetails) {
        String moduleId = moduleDetails.getId();
        try {
            String modulePropertiesFileLocation = ModuleDetailsHelper.getModulePropertiesFileLocation(warLocation, moduleId);
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(modulePropertiesFileLocation, ModuleManagementTool.DETECTOR_AMP_AND_WAR);
            if (!file.exists()) {
                file.createNewFile();
            }
            Properties moduleProperties = moduleDetails.getProperties();
            FileOutputStream os = new FileOutputStream((File)file);
            try {
                moduleProperties.store((OutputStream)os, null);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                os.close();
                throw throwable;
            }
            os.close();
            {
            }
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to save module details into WAR file: \n   Module: " + moduleDetails.getId() + "\n" + "   Properties: " + moduleDetails.getProperties(), exception);
        }
    }
}

