/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeArchiveServiceImpl
implements NodeArchiveService {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org", (String)"NodeArchive");
    private static final long LOCK_TTL = 60000L;
    private static final String MSG_BUSY = "node.archive.msg.busy";
    private static Log logger = LogFactory.getLog(NodeArchiveServiceImpl.class);
    private NodeService nodeService;
    private SearchService searchService;
    private TransactionService transactionService;
    private JobLockService jobLockService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef originalStoreRef) {
        return this.nodeService.getStoreArchiveNode(originalStoreRef);
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    @Override
    public NodeRef getArchivedNode(NodeRef originalNodeRef) {
        StoreRef orginalStoreRef = originalNodeRef.getStoreRef();
        NodeRef archiveRootNodeRef = this.nodeService.getStoreArchiveNode(orginalStoreRef);
        NodeRef archivedNodeRef = new NodeRef(archiveRootNodeRef.getStoreRef(), originalNodeRef.getId());
        return archivedNodeRef;
    }

    private ResultSet getArchivedNodes(StoreRef originalStoreRef, int skipCount, int limit) {
        NodeRef archiveParentNodeRef = this.nodeService.getStoreArchiveNode(originalStoreRef);
        StoreRef archiveStoreRef = archiveParentNodeRef.getStoreRef();
        String query = String.format("PARENT:\"%s\" AND ASPECT:\"%s\"", archiveParentNodeRef, ContentModel.ASPECT_ARCHIVED);
        SearchParameters params = new SearchParameters();
        params.addStore(archiveStoreRef);
        params.setLanguage("lucene");
        params.setQuery(query);
        params.setSkipCount(skipCount);
        params.setMaxItems(limit);
        ResultSet rs = this.searchService.query(params);
        return rs;
    }

    private BatchProcessWorkProvider<NodeRef> getArchivedNodesWorkProvider(final StoreRef originalStoreRef, final String lockToken) {
        return new BatchProcessWorkProvider<NodeRef>(){
            private VmShutdownListener vmShutdownLister = new VmShutdownListener("getArchivedNodesWorkProvider");
            private Integer workSize;
            private int skipResults = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public synchronized int getTotalEstimatedWorkSize() {
                if (this.workSize != null) return this.workSize;
                this.workSize = 0;
                ResultSet rs = null;
                try {
                    try {
                        rs = NodeArchiveServiceImpl.this.getArchivedNodes(originalStoreRef, 0, -1);
                        this.workSize = rs.length();
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Failed to get archive size", e);
                        Object var4_3 = null;
                        if (rs == null) return this.workSize;
                        rs.close();
                        return this.workSize;
                    }
                    Object var4_2 = null;
                    if (rs == null) return this.workSize;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (rs == null) throw throwable;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return this.workSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public synchronized Collection<NodeRef> getNextWork() {
                if (this.vmShutdownLister.isVmShuttingDown()) {
                    return Collections.emptyList();
                }
                try {
                    NodeArchiveServiceImpl.this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L);
                }
                catch (LockAcquisitionException e) {
                    return Collections.emptyList();
                }
                ArrayList<NodeRef> results = new ArrayList<NodeRef>(100);
                ResultSet rs = null;
                try {
                    rs = NodeArchiveServiceImpl.this.getArchivedNodes(originalStoreRef, this.skipResults, 100);
                    for (ResultSetRow row : rs) {
                        results.add(row.getNodeRef());
                    }
                    this.skipResults += results.size();
                    Object var6_6 = null;
                    if (rs == null) return results;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (rs == null) throw throwable;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return results;
            }
        };
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(final NodeRef archivedNodeRef, final NodeRef destinationNodeRef, final QName assocTypeQName, final QName assocQName) {
        RestoreNodeReport report = new RestoreNodeReport(archivedNodeRef);
        report.setTargetParentNodeRef(destinationNodeRef);
        try {
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    return NodeArchiveServiceImpl.this.nodeService.restoreNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                }
            };
            NodeRef newNodeRef = txnHelper.doInTransaction(restoreCallback, false, true);
            report.setRestoredNodeRef(newNodeRef);
            report.setStatus(RestoreNodeReport.RestoreStatus.SUCCESS);
        }
        catch (InvalidNodeRefException e) {
            report.setCause(e);
            NodeRef invalidNodeRef = e.getNodeRef();
            if (archivedNodeRef.equals((Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE);
            } else if (EqualsHelper.nullSafeEquals((Object)destinationNodeRef, (Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
            } else if (destinationNodeRef == null) {
                ChildAssociationRef originalParentAssocRef = (ChildAssociationRef)this.nodeService.getProperty(archivedNodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                NodeRef originalParentNodeRef = originalParentAssocRef.getParentRef();
                if (EqualsHelper.nullSafeEquals((Object)originalParentNodeRef, (Object)invalidNodeRef)) {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
                } else {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
                }
            } else {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            }
        }
        catch (AccessDeniedException e) {
            report.setCause((Throwable)((Object)e));
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION);
        }
        catch (Throwable e) {
            report.setCause(e);
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            logger.error((Object)"An unhandled exception stopped the restore", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempted node restore: " + report));
        }
        return report;
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(NodeRef archivedNodeRef) {
        return this.restoreArchivedNode(archivedNodeRef, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs) {
        return this.restoreArchivedNodes(archivedNodeRefs, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(archivedNodeRefs.size());
        for (NodeRef nodeRef : archivedNodeRefs) {
            RestoreNodeReport result = this.restoreArchivedNode(nodeRef, destinationNodeRef, assocTypeQName, assocQName);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot restore as there is no authenticated user.");
        }
        final List<RestoreNodeReport> results = Collections.synchronizedList(new ArrayList(1000));
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeRef entry) throws Throwable {
                AuthenticationUtil.pushAuthentication();
                try {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                    if (NodeArchiveServiceImpl.this.nodeService.exists(entry)) {
                        RestoreNodeReport report = NodeArchiveServiceImpl.this.restoreArchivedNode(entry);
                        results.add(report);
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    AuthenticationUtil.popAuthentication();
                    throw throwable;
                }
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> arrayList;
        ResultSet rs = this.getArchivedNodes(originalStoreRef, 0, -1);
        try {
            ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(1000);
            for (ResultSetRow row : rs) {
                NodeRef archivedNodeRef = row.getNodeRef();
                RestoreNodeReport result = this.restoreArchivedNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                results.add(result);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restored " + results.size() + " nodes into store " + originalStoreRef));
            }
            arrayList = results;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
        return arrayList;
    }

    @Override
    public void purgeArchivedNode(final NodeRef archivedNodeRef) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    NodeArchiveServiceImpl.this.nodeService.deleteNode(archivedNodeRef);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
                return null;
            }
        };
        txnHelper.doInTransaction(deleteCallback, false, true);
    }

    @Override
    public void purgeArchivedNodes(List<NodeRef> archivedNodes) {
        for (NodeRef archivedNodeRef : archivedNodes) {
            this.purgeArchivedNode(archivedNodeRef);
        }
    }

    @Override
    public void purgeAllArchivedNodes(StoreRef originalStoreRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot purge as there is no authenticated user.");
        }
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeRef entry) throws Throwable {
                AuthenticationUtil.pushAuthentication();
                try {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                    if (NodeArchiveServiceImpl.this.nodeService.exists(entry)) {
                        NodeArchiveServiceImpl.this.nodeService.deleteNode(entry);
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    AuthenticationUtil.popAuthentication();
                    throw throwable;
                }
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBulkOperation(String user, StoreRef originalStoreRef, BatchProcessor.BatchProcessWorker<NodeRef> worker) {
        String lockToken = null;
        try {
            try {
                lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                BatchProcessor<NodeRef> batchProcessor = new BatchProcessor<NodeRef>("ArchiveBulkPurgeOrRestore", this.transactionService.getRetryingTransactionHelper(), this.getArchivedNodesWorkProvider(originalStoreRef, lockToken), 2, 20, null, null, 1000);
                batchProcessor.process(worker, true);
            }
            catch (LockAcquisitionException e) {
                throw new AlfrescoRuntimeException(MSG_BUSY);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (lockToken == null) throw throwable;
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                throw throwable;
            }
            catch (LockAcquisitionException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (LockAcquisitionException e) {}
        if (lockToken == null) return;
        this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
        return;
    }
}

