/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rating.RatingSchemeRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingServiceImpl
implements RatingService {
    private static final Log log = LogFactory.getLog(RatingServiceImpl.class);
    private RatingSchemeRegistry schemeRegistry;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;

    public void setRatingSchemeRegistry(RatingSchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    public Map<String, RatingScheme> getRatingSchemes() {
        return this.schemeRegistry.getRatingSchemes();
    }

    @Override
    public RatingScheme getRatingScheme(String ratingSchemeName) {
        return this.schemeRegistry.getRatingSchemes().get(ratingSchemeName);
    }

    @Override
    public void applyRating(final NodeRef targetNode, final float rating, final String ratingSchemeName) throws RatingServiceException {
        final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean isCreator = this.isCurrentUserNodeCreator(targetNode);
        if (isCreator) {
            throw new RatingServiceException("Users can't rate their own content.");
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RatingServiceImpl.this.applyRating(targetNode, rating, ratingSchemeName, currentUser);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean isCurrentUserNodeCreator(NodeRef targetNode) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        Serializable creator = this.nodeService.getProperty(targetNode, ContentModel.PROP_CREATOR);
        return currentUser.equals(creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRating(NodeRef targetNode, float rating, String ratingSchemeName, String userName) throws RatingServiceException {
        QName assocQName;
        List myRatingChildren;
        RatingScheme ratingScheme;
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Applying rating ").append(rating).append(" in scheme ").append(ratingSchemeName).append(" as user ").append(userName).append(" on ").append(targetNode);
            log.debug((Object)msg.toString());
        }
        if ((ratingScheme = this.getRatingScheme(ratingSchemeName)) == null) {
            throw new RatingServiceException("Unrecognised rating scheme: " + ratingSchemeName);
        }
        if (rating < ratingScheme.getMinRating() || rating > ratingScheme.getMaxRating()) {
            throw new RatingServiceException("Rating " + rating + " violates range for " + ratingScheme);
        }
        if (!this.nodeService.hasAspect(targetNode, ContentModel.ASPECT_RATEABLE)) {
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addAspect(targetNode, ContentModel.ASPECT_RATEABLE, null);
                Object var7_6 = null;
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
        }
        if ((myRatingChildren = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, (QNamePattern)(assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)userName)))).isEmpty()) {
            HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
            ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
            ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
            ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.createNode(targetNode, ContentModel.ASSOC_RATINGS, assocQName, ContentModel.TYPE_RATING, ratingProps);
                Object var10_12 = null;
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
        } else {
            if (myRatingChildren.size() > 1 && log.isDebugEnabled()) {
                log.debug((Object)"");
            }
            NodeRef myPreviousRatingsNode = ((ChildAssociationRef)myRatingChildren.get(0)).getChildRef();
            Map existingProps = this.nodeService.getProperties(myPreviousRatingsNode);
            String existingRatingScheme = (String)existingProps.get(ContentModel.PROP_RATING_SCHEME);
            if (ratingScheme.getName().equals(existingRatingScheme)) {
                HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
                ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
                ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
                ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
                this.nodeService.setProperties(myPreviousRatingsNode, ratingProps);
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot apply rating ").append(rating).append(" [").append(ratingSchemeName).append("] to node ").append(targetNode).append(". Already rated in ").append(existingRatingScheme);
                throw new RatingServiceException(msg.toString());
            }
        }
    }

    @Override
    public Rating getRatingByCurrentUser(NodeRef targetNode, String ratingSchemeName) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.getRating(targetNode, ratingSchemeName, currentUser);
    }

    private Rating getRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef ratingNodeAssoc = ratingChildren.get(0);
        Map properties = this.nodeService.getProperties(ratingNodeAssoc.getChildRef());
        String existingRatingScheme = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        if (!existingRatingScheme.equals(ratingSchemeName)) {
            return null;
        }
        Float existingRatingScore = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date existingRatingDate = (Date)properties.get(ContentModel.PROP_RATED_AT);
        Rating result = new Rating(this.getRatingScheme(existingRatingScheme), existingRatingScore.floatValue(), user, existingRatingDate);
        return result;
    }

    @Override
    public Rating removeRatingByCurrentUser(NodeRef targetNode, String ratingScheme) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.removeRating(targetNode, ratingScheme, currentUser);
    }

    private Rating removeRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef child = ratingChildren.get(0);
        Map properties = this.nodeService.getProperties(child.getChildRef());
        Rating result = null;
        if (ratingSchemeName.equals(properties.get(ContentModel.PROP_RATING_SCHEME))) {
            Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
            Date date = (Date)properties.get(ContentModel.PROP_RATED_AT);
            this.nodeService.deleteNode(child.getChildRef());
            result = new Rating(this.getRatingScheme(ratingSchemeName), score.floatValue(), user, date);
        }
        return result;
    }

    @Override
    public float getTotalRating(NodeRef targetNode, String ratingSchemeName) {
        List<ChildAssociationRef> ratingsNodes = this.getRatingNodeChildren(targetNode, null);
        float result = 0.0f;
        for (ChildAssociationRef ratingsNode : ratingsNodes) {
            Rating rating = this.getRatingFrom(ratingsNode.getChildRef());
            if (!rating.getScheme().getName().equals(ratingSchemeName)) continue;
            result += rating.getScore();
        }
        return result;
    }

    @Override
    public float getAverageRating(NodeRef targetNode, String ratingSchemeName) {
        List<ChildAssociationRef> ratingsNodes = this.getRatingNodeChildren(targetNode, null);
        int ratingCount = 0;
        float ratingTotal = 0.0f;
        for (ChildAssociationRef ratingsNode : ratingsNodes) {
            Rating rating = this.getRatingFrom(ratingsNode.getChildRef());
            if (!rating.getScheme().getName().equals(ratingSchemeName)) continue;
            ++ratingCount;
            ratingTotal += rating.getScore();
        }
        if (ratingCount == 0) {
            return -1.0f;
        }
        return ratingTotal / (float)ratingCount;
    }

    @Override
    public int getRatingsCount(NodeRef targetNode, String ratingSchemeName) {
        List<ChildAssociationRef> ratingsNodes = this.getRatingNodeChildren(targetNode, null);
        int result = 0;
        for (ChildAssociationRef ratingsNode : ratingsNodes) {
            Rating rating = this.getRatingFrom(ratingsNode.getChildRef());
            if (!rating.getScheme().getName().equals(ratingSchemeName)) continue;
            ++result;
        }
        return result;
    }

    private List<ChildAssociationRef> getRatingNodeChildren(NodeRef targetNode, String user) {
        Object qnamePattern = null;
        qnamePattern = user != null ? QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)user) : RegexQNamePattern.MATCH_ALL;
        List results = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, qnamePattern);
        return results;
    }

    private Rating getRatingFrom(NodeRef ratingNode) {
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(ratingNode);
        String appliedBy = parentAssoc.getQName().getLocalName();
        Map properties = this.nodeService.getProperties(ratingNode);
        String schemeName = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date ratedAt = (Date)properties.get(ContentModel.PROP_RATED_AT);
        RatingScheme scheme = this.getRatingScheme(schemeName);
        Rating result = new Rating(scheme, score.floatValue(), appliedBy, ratedAt);
        return result;
    }
}

