/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class MultiUserRenditionTest {
    private static ApplicationContext appContext;
    private static String ADMIN_USER;
    private static final String NON_ADMIN_USER = "nonAdmin";
    private static MutableAuthenticationService authenticationService;
    private static ContentService contentService;
    private static NodeService nodeService;
    private static PermissionService permissionService;
    private static PersonService personService;
    private static RenditionService renditionService;
    private static Repository repositoryHelper;
    private static RetryingTransactionHelper txnHelper;
    private static TransactionService transactionService;
    private List<NodeRef> nodesToBeTidiedUp = new ArrayList<NodeRef>();
    private NodeRef testFolder;

    @BeforeClass
    public static void initContextAndCreateUser() {
        appContext = ApplicationContextHelper.getApplicationContext();
        authenticationService = (MutableAuthenticationService)appContext.getBean("AuthenticationService");
        contentService = (ContentService)appContext.getBean("ContentService");
        nodeService = (NodeService)appContext.getBean("NodeService");
        permissionService = (PermissionService)appContext.getBean("PermissionService");
        personService = (PersonService)appContext.getBean("PersonService");
        renditionService = (RenditionService)appContext.getBean("RenditionService");
        repositoryHelper = (Repository)appContext.getBean("repositoryHelper");
        transactionService = (TransactionService)appContext.getBean("TransactionService");
        txnHelper = transactionService.getRetryingTransactionHelper();
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        MultiUserRenditionTest.createUser(NON_ADMIN_USER);
    }

    public static void createUser(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        if (!authenticationService.authenticationExists(userName)) {
            authenticationService.createAuthentication(userName, userName.toCharArray());
        }
        if (!personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap();
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            personService.createPerson(ppOne);
        }
    }

    @Before
    public void createTestFolder() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, this.getClass() + "_testFolder");
        this.testFolder = nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(this.testFolder, "GROUP_EVERYONE", "All", true);
        this.nodesToBeTidiedUp.add(this.testFolder);
    }

    @Test
    public void renditioningShouldNotChangeModifierOnSourceNode_ALF3991() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        final NodeRef adminPdfNode = txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return MultiUserRenditionTest.this.createPdfDocumentAsCurrentlyAuthenticatedUser(ADMIN_USER + "_content");
            }
        });
        this.nodesToBeTidiedUp.add(adminPdfNode);
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        final NodeRef nonAdminPdfNode = txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return MultiUserRenditionTest.this.createPdfDocumentAsCurrentlyAuthenticatedUser("nonAdmin_content");
            }
        });
        this.nodesToBeTidiedUp.add(nonAdminPdfNode);
        final RenditionDefinition doclibRD = renditionService.loadRenditionDefinition(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"doclib"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                renditionService.render(nonAdminPdfNode, doclibRD);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)NON_ADMIN_USER);
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                renditionService.render(adminPdfNode, doclibRD);
                return null;
            }
        });
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((String)"Incorrect modifier property", (Object)ADMIN_USER, (Object)nodeService.getProperty(adminPdfNode, ContentModel.PROP_MODIFIER));
                Assert.assertEquals((String)"Incorrect modifier property", (Object)MultiUserRenditionTest.NON_ADMIN_USER, (Object)nodeService.getProperty(nonAdminPdfNode, ContentModel.PROP_MODIFIER));
                return null;
            }
        });
    }

    @After
    public void tidyUpUnwantedNodeRefs() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (NodeRef node : MultiUserRenditionTest.this.nodesToBeTidiedUp) {
                    if (!nodeService.exists(node)) continue;
                    nodeService.deleteNode(node);
                }
                return null;
            }
        });
        this.nodesToBeTidiedUp.clear();
    }

    private NodeRef createPdfDocumentAsCurrentlyAuthenticatedUser(String nodeName) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeName);
        NodeRef result = nodeService.createNode(this.testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), ContentModel.TYPE_CONTENT, props).getChildRef();
        File file = this.loadQuickPdfFile();
        ContentWriter writer = contentService.getWriter(result, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/pdf");
        writer.setEncoding("UTF-8");
        writer.putContent(file);
        return result;
    }

    private File loadQuickPdfFile() {
        File file;
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/quick.pdf");
        if (url == null) {
            Assert.fail((String)"Could not load pdf file");
        }
        if (!(file = new File(url.getFile())).exists()) {
            Assert.fail((String)"Could not load pdf file");
        }
        return file;
    }
}

