/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateNodeRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnCreateNodePolicy {
    private static Log logger = LogFactory.getLog(CreateNodeRuleTrigger.class);
    private static final String POLICY = "onCreateNode";
    private static final QName ASPECT_NO_CONTENT = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"noContent");
    private boolean isClassBehaviour = false;
    RuntimeRuleService ruleService;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void setRuleService(RuntimeRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), this, (Behaviour)new JavaBehaviour(this, POLICY));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), this, (Behaviour)new JavaBehaviour(this, POLICY));
        }
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ASPECT_NO_CONTENT, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, ASPECT_NO_CONTENT, (Behaviour)new JavaBehaviour(this, "onRemoveAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef;
        if (childAssocRef != null && (nodeRef = childAssocRef.getChildRef()) != null && this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ASPECT_NO_CONTENT)) {
            NodeRef parentNodeRef = childAssocRef.getParentRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create node rule trigger fired for parent node " + this.nodeService.getType(parentNodeRef).toString() + " " + parentNodeRef + " and child node " + this.nodeService.getType(nodeRef).toString() + " " + nodeRef));
            }
            this.triggerRules(parentNodeRef, nodeRef);
        }
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ASPECT_NO_CONTENT)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing the pending rules for the node " + nodeRef.toString() + " since the noContent aspect has been applied."));
            }
            this.ruleService.removeRulePendingExecution(nodeRef);
        }
    }

    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ASPECT_NO_CONTENT)) {
            NodeRef parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create node rule trigger fired for parent node " + this.nodeService.getType(parentNodeRef).toString() + " " + parentNodeRef + " and child node " + this.nodeService.getType(nodeRef).toString() + " " + nodeRef + " (this was triggered on removal of the noContent aspect)"));
            }
            this.triggerRules(parentNodeRef, nodeRef);
        }
    }
}

