/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.List;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.SupportsBackgroundIndexing;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerAndSearcherFactory;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMLuceneIndexerAndSearcherFactory
extends AbstractLuceneIndexerAndSearcherFactory
implements SupportsBackgroundIndexing {
    protected DictionaryService dictionaryService;
    private NamespaceService nameSpaceService;
    protected NodeService nodeService;
    protected FullTextSearchIndexer fullTextSearchIndexer;
    protected ContentService contentService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNameSpaceService(NamespaceService nameSpaceService) {
        this.nameSpaceService = nameSpaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    protected LuceneIndexer createIndexer(StoreRef storeRef, String deltaId) {
        storeRef = this.tenantService.getName(storeRef);
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(storeRef, deltaId, this);
        indexer.setNodeService(this.nodeService);
        indexer.setTenantService(this.tenantService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setFullTextSearchIndexer(this.fullTextSearchIndexer);
        indexer.setContentService(this.contentService);
        indexer.setMaxAtomicTransformationTime(this.getMaxTransformationTime());
        return indexer;
    }

    @Override
    protected LuceneSearcher getSearcher(StoreRef storeRef, LuceneIndexer indexer) throws SearcherException {
        storeRef = this.tenantService.getName(storeRef);
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(storeRef, indexer, this);
        searcher.setNamespacePrefixResolver((NamespacePrefixResolver)this.nameSpaceService);
        searcher.setNodeService(this.nodeService);
        searcher.setTenantService(this.tenantService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryRegister(this.getQueryRegister());
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryLanguages(this.queryLanguages);
        return searcher;
    }

    @Override
    protected SearchService getNodeSearcher() throws SearcherException {
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getNodeSearcher();
        searcher.setNamespacePrefixResolver((NamespacePrefixResolver)this.nameSpaceService);
        searcher.setNodeService(this.nodeService);
        searcher.setTenantService(this.tenantService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryRegister(this.getQueryRegister());
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryLanguages(this.queryLanguages);
        return searcher;
    }

    @Override
    protected List<StoreRef> getAllStores() {
        return this.nodeService.getStores();
    }
}

