/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.MultiReader;

public class MultiReaderTest
extends TestCase {
    public MultiReaderTest() {
    }

    public MultiReaderTest(String arg0) {
        super(arg0);
    }

    public void testMultiReader_single() throws IOException {
        int c;
        String first = "my first string";
        String second = "another little string";
        StringReader one = new StringReader(first);
        StringReader two = new StringReader(second);
        MultiReader multiReader = new MultiReader(one, two);
        StringBuilder builder = new StringBuilder();
        while ((c = multiReader.read()) != -1) {
            builder.append((char)c);
        }
        MultiReaderTest.assertEquals((String)builder.toString(), (String)(first + second));
    }

    public void testMultiReader_bits() throws IOException {
        String first = "my first string";
        String second = "another little string";
        StringReader one = new StringReader(first);
        StringReader two = new StringReader(second);
        MultiReader multiReader = new MultiReader(one, two);
        StringBuilder builder = new StringBuilder();
        for (int chunk = 1; chunk < 100; ++chunk) {
            char[] c = new char[chunk];
            int i = 0;
            while (i != -1) {
                i = multiReader.read(c);
                for (int j = 0; j < i; ++j) {
                    builder.append(c[j]);
                }
            }
            MultiReaderTest.assertEquals((String)builder.toString(), (String)(first + second));
        }
    }

    public void testSkip() throws IOException {
        String first = "my first string";
        String second = "another little string";
        StringReader one = new StringReader(first);
        StringReader two = new StringReader(second);
        MultiReader multiReader = new MultiReader(one, two);
        multiReader.skip(3L);
        String all = first + second;
        MultiReaderTest.assertEquals((char)((char)multiReader.read()), (char)all.charAt(3));
        multiReader.skip(15L);
        MultiReaderTest.assertEquals((char)((char)multiReader.read()), (char)all.charAt(19));
    }
}

