/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.results.SortedResultSetRow;
import org.alfresco.repo.search.results.SortedResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedResultSet
implements ResultSet {
    ArrayList<NodeRefAndScore> nodeRefsAndScores;
    NodeService nodeService;
    SearchParameters searchParameters;
    ResultSet resultSet;

    public SortedResultSet(ResultSet resultSet, NodeService nodeService, SearchParameters searchParameters, NamespacePrefixResolver namespacePrefixResolver) {
        this.nodeService = nodeService;
        this.searchParameters = searchParameters;
        this.resultSet = resultSet;
        this.nodeRefsAndScores = new ArrayList(resultSet.length());
        for (ResultSetRow row : resultSet) {
            this.nodeRefsAndScores.add(new NodeRefAndScore(row.getNodeRef(), row.getScore()));
        }
        ArrayList<AttributeOrder> order = new ArrayList<AttributeOrder>();
        for (SearchParameters.SortDefinition sd : searchParameters.getSortDefinitions()) {
            switch (sd.getSortType()) {
                case FIELD: {
                    String field = sd.getField();
                    if (!field.startsWith("@")) break;
                    QName qname = this.expandAttributeFieldName(field, namespacePrefixResolver);
                    order.add(new AttributeOrder(qname, sd.isAscending()));
                    break;
                }
                case DOCUMENT: {
                    break;
                }
            }
        }
        this.orderNodes(this.nodeRefsAndScores, order);
    }

    public void close() {
        this.resultSet.close();
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return this.nodeService.getPrimaryParent(this.nodeRefsAndScores.get((int)n).nodeRef);
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            nodeRefs.add(row.getNodeRef());
        }
        return nodeRefs;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            cars.add(row.getChildAssocRef());
        }
        return cars;
    }

    public NodeRef getNodeRef(int n) {
        return this.nodeRefsAndScores.get((int)n).nodeRef;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSet.getResultSetMetaData();
    }

    public ResultSetRow getRow(int i) {
        if (i < this.length()) {
            return new SortedResultSetRow(this, i);
        }
        throw new SearcherException("Invalid row");
    }

    public float getScore(int n) {
        return this.nodeRefsAndScores.get((int)n).score;
    }

    public int length() {
        return this.nodeRefsAndScores.size();
    }

    public Iterator<ResultSetRow> iterator() {
        return new SortedResultSetRowIterator(this);
    }

    private void orderNodes(List<NodeRefAndScore> answer, List<AttributeOrder> order) {
        Collections.sort(answer, new NodeRefAndScoreComparator(this.nodeService, order));
    }

    private QName expandAttributeFieldName(String field, NamespacePrefixResolver namespacePrefixResolver) {
        int colonPosition;
        QName qname = field.charAt(1) != '{' ? ((colonPosition = field.indexOf(58)) == -1 ? QName.createQName((String)"", (String)field.substring(1)) : QName.createQName((String)field.substring(1, colonPosition), (String)field.substring(colonPosition + 1), (NamespacePrefixResolver)namespacePrefixResolver)) : QName.createQName((String)field.substring(1));
        return qname;
    }

    public int getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMore() {
        throw new UnsupportedOperationException();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return this.resultSet.setBulkFetch(bulkFetch);
    }

    public boolean getBulkFetch() {
        return this.resultSet.getBulkFetch();
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return this.resultSet.setBulkFetchSize(bulkFetchSize);
    }

    public int getBulkFetchSize() {
        return this.resultSet.getBulkFetchSize();
    }

    private static class NodeRefAndScore {
        NodeRef nodeRef;
        float score;

        NodeRefAndScore(NodeRef nodeRef, float score) {
            this.nodeRef = nodeRef;
            this.score = score;
        }
    }

    private static class AttributeOrder {
        QName attribute;
        boolean ascending;

        AttributeOrder(QName attribute, boolean ascending) {
            this.attribute = attribute;
            this.ascending = ascending;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeRefAndScoreComparator
    implements Comparator<NodeRefAndScore> {
        List<AttributeOrder> order;
        NodeService nodeService;

        NodeRefAndScoreComparator(NodeService nodeService, List<AttributeOrder> order) {
            this.nodeService = nodeService;
            this.order = order;
        }

        @Override
        public int compare(NodeRefAndScore n1, NodeRefAndScore n2) {
            for (AttributeOrder attributeOrder : this.order) {
                Serializable o1 = this.nodeService.getProperty(n1.nodeRef, attributeOrder.attribute);
                Serializable o2 = this.nodeService.getProperty(n2.nodeRef, attributeOrder.attribute);
                if (o1 == null) {
                    if (o2 == null) continue;
                    return attributeOrder.ascending ? -1 : 1;
                }
                if (o2 == null) {
                    return attributeOrder.ascending ? 1 : -1;
                }
                if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) continue;
                return (attributeOrder.ascending ? 1 : -1) * ((Comparable)((Object)o1)).compareTo((Comparable)((Object)o2));
            }
            return 0;
        }
    }
}

