/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.util.PropertyCheck;

public class TenantAwareUserNameGenerator
implements UserNameGenerator {
    private TenantService tenantService;
    private UserNameGenerator generator;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"generator", (Object)this.generator);
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public String generateUserName(String firstName, String lastName, String emailAddress, int seed) {
        String userName = this.generator.generateUserName(firstName, lastName, emailAddress, seed);
        if (this.tenantService.isEnabled()) {
            userName = this.tenantService.getDomainUser(userName, this.tenantService.getCurrentUserDomain());
        }
        return userName;
    }

    public void setGenerator(UserNameGenerator generator) {
        this.generator = generator;
    }

    public UserNameGenerator getGenerator() {
        return this.generator;
    }
}

