/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthorityServiceImpl
implements AuthorityService {
    private PersonService personService;
    private NodeService nodeService;
    private Set<String> adminSet = Collections.singleton("ROLE_ADMINISTRATOR");
    private Set<String> guestSet = Collections.singleton("ROLE_GUEST");
    private Set<String> allSet = Collections.singleton("GROUP_EVERYONE");
    private Set<String> adminUsers;
    private AuthenticationContext authenticationContext;
    private Set<String> guestUsers;
    private TenantService tenantService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public boolean hasAdminAuthority() {
        String currentUserName = this.authenticationContext.getCurrentUserName();
        return currentUserName != null && (this.adminUsers.contains(currentUserName) || this.adminUsers.contains(this.tenantService.getBaseNameUser(currentUserName)));
    }

    @Override
    public boolean isAdminAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.adminUsers.contains(canonicalName);
    }

    @Override
    public boolean hasGuestAuthority() {
        String currentUserName = this.authenticationContext.getCurrentUserName();
        return currentUserName != null && (this.guestUsers.contains(currentUserName) || this.guestUsers.contains(this.tenantService.getBaseNameUser(currentUserName)));
    }

    @Override
    public boolean isGuestAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.guestUsers.contains(canonicalName);
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setAdminUsers(Set<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public void setGuestUsers(Set<String> guestUsers) {
        this.guestUsers = guestUsers;
    }

    @Override
    public Set<String> getAuthorities() {
        HashSet<String> authorities = new HashSet<String>();
        String currentUserName = this.authenticationContext.getCurrentUserName();
        if (this.adminUsers.contains(currentUserName)) {
            authorities.addAll(this.adminSet);
        } else if (!this.guestUsers.contains(currentUserName)) {
            authorities.addAll(this.allSet);
        }
        return authorities;
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        HashSet<String> authorities = new HashSet<String>();
        switch (type) {
            case ADMIN: {
                authorities.addAll(this.adminSet);
                break;
            }
            case EVERYONE: {
                authorities.addAll(this.allSet);
                break;
            }
            case GUEST: {
                authorities.addAll(this.guestSet);
                break;
            }
            case GROUP: {
                authorities.addAll(this.allSet);
                break;
            }
            case OWNER: {
                break;
            }
            case ROLE: {
                break;
            }
            case USER: {
                for (NodeRef personRef : this.personService.getAllPeople()) {
                    authorities.add((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME)));
                }
                break;
            }
        }
        return authorities;
    }

    @Override
    public void addAuthority(String parentName, String childName) {
    }

    @Override
    public void addAuthority(Collection<String> parentNames, String childName) {
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName) {
        return "";
    }

    @Override
    public void deleteAuthority(String name) {
    }

    @Override
    public void deleteAuthority(String name, boolean cascade) {
    }

    @Override
    public Set<String> getAllRootAuthorities(AuthorityType type) {
        return this.getAllAuthorities(type);
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        return Collections.emptySet();
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        if (type.isFixedString()) {
            return type.getFixedString();
        }
        if (type.isPrefixed()) {
            return type.getPrefixString() + shortName;
        }
        return shortName;
    }

    @Override
    public String getShortName(String name) {
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        if (type.isFixedString()) {
            return "";
        }
        if (type.isPrefixed()) {
            return name.substring(type.getPrefixString().length());
        }
        return name;
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
    }

    @Override
    public boolean authorityExists(String name) {
        return false;
    }

    @Override
    public Set<String> getAuthoritiesForUser(String currentUserName) {
        HashSet<String> authorities = new HashSet<String>();
        if (this.adminUsers.contains(currentUserName)) {
            authorities.addAll(this.adminSet);
        }
        if (AuthorityType.getAuthorityType((String)currentUserName) != AuthorityType.GUEST) {
            authorities.addAll(this.allSet);
        }
        return authorities;
    }

    @Override
    public String getAuthorityDisplayName(String name) {
        return "";
    }

    @Override
    public void setAuthorityDisplayName(String authorityName, String authorityDisplayName) {
    }

    @Override
    public Set<String> getAllAuthoritiesInZone(String zoneName, AuthorityType type) {
        return Collections.emptySet();
    }

    @Override
    public NodeRef getOrCreateZone(String zoneName) {
        return null;
    }

    @Override
    public void addAuthorityToZones(String authorityName, Set<String> zones) {
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName, String authorityDisplayName, Set<String> authorityZones) {
        return "";
    }

    @Override
    public Set<String> getAllRootAuthoritiesInZone(String zoneName, AuthorityType type) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getAuthorityZones(String name) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDefaultZones() {
        return Collections.emptySet();
    }

    @Override
    public void removeAuthorityFromZones(String authorityName, Set<String> zones) {
    }

    @Override
    public NodeRef getZone(String zoneName) {
        return null;
    }

    @Override
    public Set<String> findAuthorities(AuthorityType type, String parentAuthority, boolean immediate, String displayNamePattern, String zoneName) {
        return Collections.emptySet();
    }
}

