/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionReference;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPermission
extends AbstractPermissionReference
implements XMLModelInitialisable {
    private static final String NAME = "name";
    private static final String REQUIRED_PERMISSION = "requiredPermission";
    private static final String RP_NAME = "name";
    private static final String RP_TYPE = "type";
    private static final String RP_ON = "on";
    private static final String RP_IMPLIES = "implies";
    private static final String NODE_ENTRY = "node";
    private static final String PARENT_ENTRY = "parent";
    private static final String CHILDREN_ENTRY = "children";
    private String name;
    private QName typeQName;
    private Set<RequiredPermission> requiredPermissions = new HashSet<RequiredPermission>();

    protected AbstractPermission(QName typeQName) {
        this.typeQName = typeQName;
    }

    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        this.name = element.attributeValue("name");
        Iterator rpit = element.elementIterator(REQUIRED_PERMISSION);
        while (rpit.hasNext()) {
            RequiredPermission.On on;
            Element requiredPermissionElement = (Element)rpit.next();
            Attribute typeAttribute = requiredPermissionElement.attribute(RP_TYPE);
            QName qName = typeAttribute != null ? QName.createQName((String)typeAttribute.getStringValue(), (NamespacePrefixResolver)nspr) : this.typeQName;
            String requiredName = requiredPermissionElement.attributeValue("name");
            String onString = requiredPermissionElement.attributeValue(RP_ON);
            if (onString.equalsIgnoreCase(NODE_ENTRY)) {
                on = RequiredPermission.On.NODE;
            } else if (onString.equalsIgnoreCase(PARENT_ENTRY)) {
                on = RequiredPermission.On.PARENT;
            } else if (onString.equalsIgnoreCase(CHILDREN_ENTRY)) {
                on = RequiredPermission.On.CHILDREN;
            } else {
                throw new PermissionModelException("Required permission must specify parent or node for the on attribute.");
            }
            boolean implies = false;
            Attribute impliesAttribute = requiredPermissionElement.attribute(RP_IMPLIES);
            if (impliesAttribute != null) {
                implies = Boolean.parseBoolean(impliesAttribute.getStringValue());
            }
            RequiredPermission rq = new RequiredPermission(qName, requiredName, on, implies);
            this.requiredPermissions.add(rq);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Set<RequiredPermission> getRequiredPermissions() {
        return Collections.unmodifiableSet(this.requiredPermissions);
    }

    public final QName getTypeQName() {
        return this.typeQName;
    }

    @Override
    public final QName getQName() {
        return this.getTypeQName();
    }
}

