/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class PermissionModelTest
extends AbstractPermissionTest {
    public void testWoof() {
        QName typeQname = this.nodeService.getType(this.rootNodeRef);
        Set aspectQNames = this.nodeService.getAspects(this.rootNodeRef);
        PermissionReference ref = this.permissionModelDAO.getPermissionReference(null, "CheckOut");
        Set<PermissionReference> answer = this.permissionModelDAO.getRequiredPermissions(ref, typeQname, aspectQNames, RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)1, (int)answer.size());
    }

    public void testIncludePermissionGroups() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Consumer"));
        PermissionModelTest.assertEquals((int)8, (int)grantees.size());
    }

    public void testIncludePermissionGroups2() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Contributor"));
        PermissionModelTest.assertEquals((int)16, (int)grantees.size());
    }

    public void testIncludePermissionGroups3() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Editor"));
        PermissionModelTest.assertEquals((int)19, (int)grantees.size());
    }

    public void testIncludePermissionGroups4() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Collaborator"));
        PermissionModelTest.assertEquals((int)26, (int)grantees.size());
    }

    public void testIncludePermissionGroups5() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Coordinator"));
        PermissionModelTest.assertEquals((int)103, (int)grantees.size());
    }

    public void testIncludePermissionGroups6() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "RecordAdministrator"));
        PermissionModelTest.assertEquals((int)19, (int)grantees.size());
    }

    public void testGetGrantingPermissions() {
        Set<PermissionReference> granters = this.permissionModelDAO.getGrantingPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "ReadProperties"));
        PermissionModelTest.assertEquals((int)18, (int)granters.size());
        granters = this.permissionModelDAO.getGrantingPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "_ReadProperties"));
        PermissionModelTest.assertEquals((int)19, (int)granters.size());
    }

    public void testGlobalPermissions() {
        Set<? extends PermissionEntry> globalPermissions = this.permissionModelDAO.getGlobalPermissionEntries();
        PermissionModelTest.assertEquals((int)6, (int)globalPermissions.size());
    }

    public void testRequiredPermissions() {
        Set<PermissionReference> required = this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "Read"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)3, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "ReadContent"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)1, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "_ReadContent"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)0, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), "Coordinator"), QName.createQName((String)"cm", (String)"cmobject", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)18, (int)required.size());
        required = this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "FullControl"), QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        PermissionModelTest.assertEquals((int)18, (int)required.size());
    }

    public void testMultiThreadedAccess() {
        Thread runner = null;
        for (int i = 0; i < 20; ++i) {
            runner = new Nester("Concurrent-" + i, runner);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void testNulls() {
        this.permissionModelDAO.getRequiredPermissions(null, QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getRequiredPermissions(SimplePermissionReference.getPermissionReference(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)this.namespacePrefixResolver), "Read"), null, Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getRequiredPermissions(null, null, Collections.<QName>emptySet(), RequiredPermission.On.NODE);
        this.permissionModelDAO.getGranteePermissions(null);
        this.permissionModelDAO.getGlobalPermissionEntries().contains(null);
    }

    class Nester
    extends Thread {
        Thread waiter;

        Nester(String name, Thread waiter) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: {
                PermissionModelTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                if (this.waiter != null) {
                    this.waiter.start();
                }
                try {
                    try {
                        System.out.println("Start " + this.getName());
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> queryPermissionModel = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Throwable {
                                Random random = new Random();
                                Set<PermissionReference> toTest = PermissionModelTest.this.permissionModelDAO.getAllPermissions(QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)PermissionModelTest.this.namespacePrefixResolver));
                                for (int i = 0; i < 10000; ++i) {
                                    for (PermissionReference pr : toTest) {
                                        if (!(random.nextFloat() < 0.5f)) continue;
                                        PermissionModelTest.this.permissionModelDAO.getRequiredPermissions(pr, QName.createQName((String)"sys", (String)"base", (NamespacePrefixResolver)PermissionModelTest.this.namespacePrefixResolver), Collections.<QName>emptySet(), RequiredPermission.On.NODE);
                                    }
                                }
                                return null;
                            }
                        };
                        PermissionModelTest.this.retryingTransactionHelper.doInTransaction(queryPermissionModel);
                        System.out.println("End " + this.getName());
                    }
                    catch (Exception e) {
                        System.out.println("End " + this.getName() + " with error " + e.getMessage());
                        e.printStackTrace();
                        Object var3_5 = null;
                        PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
                        break block7;
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
                    throw throwable;
                }
                PermissionModelTest.this.authenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter == null) return;
            try {
                this.waiter.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

