/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.sync.NodeDescription;
import org.alfresco.repo.security.sync.UserRegistry;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TraceableThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingUserRegistrySynchronizer
extends AbstractLifecycleBean
implements UserRegistrySynchronizer,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(ChainingUserRegistrySynchronizer.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ChainingUserRegistrySynchronizer");
    private static final long LOCK_TTL = 120000L;
    public static final String ROOT_ATTRIBUTE_PATH = ".ChainingUserRegistrySynchronizer";
    private static final String GROUP_LAST_MODIFIED_ATTRIBUTE = "GROUP";
    private static final String PERSON_LAST_MODIFIED_ATTRIBUTE = "PERSON";
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;
    private AuthorityService authorityService;
    private PersonService personService;
    private AttributeService attributeService;
    private TransactionService transactionService;
    private RuleService ruleService;
    private JobLockService jobLockService;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean syncWhenMissingPeopleLogIn = true;
    private boolean syncOnStartup = true;
    private boolean autoCreatePeopleOnLogin = true;
    private int loggingInterval = 100;
    private int workerThreads = 2;

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setAutoCreatePeopleOnLogin(boolean autoCreatePeopleOnLogin) {
        this.autoCreatePeopleOnLogin = autoCreatePeopleOnLogin;
    }

    public void setSyncWhenMissingPeopleLogIn(boolean syncWhenMissingPeopleLogIn) {
        this.syncWhenMissingPeopleLogIn = syncWhenMissingPeopleLogIn;
    }

    public void setSyncOnStartup(boolean syncOnStartup) {
        this.syncOnStartup = syncOnStartup;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    /*
     * Loose catch block
     */
    @Override
    public void synchronize(boolean forceUpdate, boolean allowDeletions, final boolean splitTxns) {
        block20: {
            if (this.transactionService.isReadOnly()) {
                logger.warn((Object)"Unable to proceed with user registry synchronization. Repository is read only.");
                return;
            }
            String lockToken = null;
            TraceableThreadFactory threadFactory = new TraceableThreadFactory();
            threadFactory.setNamePrefix("ChainingUserRegistrySynchronizer lock refresh");
            threadFactory.setThreadDaemon(true);
            ScheduledThreadPoolExecutor lockRefresher = new ScheduledThreadPoolExecutor(1, threadFactory);
            try {
                lockToken = splitTxns ? this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    @Override
                    public String execute() throws Throwable {
                        return ChainingUserRegistrySynchronizer.this.jobLockService.getLock(LOCK_QNAME, 120000L, 0L, 1);
                    }
                }, false, splitTxns) : this.jobLockService.getLock(LOCK_QNAME, 120000L, 3000L, 10);
            }
            catch (LockAcquisitionException e) {
                logger.warn((Object)"User registry synchronization already running in another thread. Synchronize aborted");
                Object var17_10 = null;
                if (lockToken != null) {
                    lockRefresher.shutdown();
                    try {
                        lockRefresher.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    String token2 = lockToken;
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(token2){
                        final /* synthetic */ String val$token;
                        {
                            this.val$token = string;
                        }

                        @Override
                        public Object execute() throws Throwable {
                            ChainingUserRegistrySynchronizer.this.jobLockService.releaseLock(this.val$token, LOCK_QNAME);
                            return null;
                        }
                    }, false, splitTxns);
                }
                return;
            }
            final String token = lockToken;
            lockRefresher.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            ChainingUserRegistrySynchronizer.this.jobLockService.refreshLock(token, LOCK_QNAME, 120000L);
                            return null;
                        }
                    }, false, splitTxns);
                }
            }, 60000L, 60000L, TimeUnit.MILLISECONDS);
            TreeSet<String> visitedZoneIds = new TreeSet<String>();
            Collection<String> instanceIds = this.applicationContextManager.getInstanceIds();
            TreeSet<String> allZoneIds = new TreeSet<String>();
            for (String id : instanceIds) {
                allZoneIds.add("AUTH.EXT." + id);
            }
            for (String id : instanceIds) {
                ApplicationContext context = this.applicationContextManager.getApplicationContext(id);
                try {
                    UserRegistry plugin = (UserRegistry)context.getBean(this.sourceBeanName);
                    if (plugin instanceof ActivateableBean && !((ActivateableBean)((Object)plugin)).isActive()) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Synchronizing users and groups with user registry '" + id + "'"));
                    }
                    if (allowDeletions && logger.isWarnEnabled()) {
                        logger.warn((Object)("Full synchronization with user registry '" + id + "'; some users and groups previously created by synchronization with this user registry may be removed."));
                    }
                    boolean requiresNew = splitTxns || AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
                    this.syncWithPlugin(id, plugin, forceUpdate, allowDeletions, requiresNew, visitedZoneIds, allZoneIds);
                }
                catch (NoSuchBeanDefinitionException e) {}
            }
            Object var17_11 = null;
            if (lockToken == null) break block20;
            lockRefresher.shutdown();
            try {
                lockRefresher.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            String token2 = lockToken;
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new /* invalid duplicate definition of identical inner class */, false, splitTxns);
            {
                break block20;
                catch (RuntimeException e) {
                    logger.error((Object)"Synchronization aborted due to error", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var17_12 = null;
                if (lockToken != null) {
                    lockRefresher.shutdown();
                    try {
                        lockRefresher.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    token2 = lockToken;
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(new /* invalid duplicate definition of identical inner class */, false, splitTxns);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Set<QName> getPersonMappedProperties(String username) {
        Set<String> authorityZones = this.authorityService.getAuthorityZones(username);
        if (authorityZones == null) {
            return Collections.emptySet();
        }
        Collection<String> instanceIds = this.applicationContextManager.getInstanceIds();
        for (String id : instanceIds) {
            String zoneId = "AUTH.EXT." + id;
            if (!authorityZones.contains(zoneId)) continue;
            ApplicationContext context = this.applicationContextManager.getApplicationContext(id);
            try {
                UserRegistry plugin = (UserRegistry)context.getBean(this.sourceBeanName);
                if (plugin instanceof ActivateableBean && !((ActivateableBean)((Object)plugin)).isActive()) continue;
                return plugin.getPersonMappedProperties();
            }
            catch (NoSuchBeanDefinitionException e) {
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean createMissingPerson(String userName) {
        if (userName != null && !userName.equals(AuthenticationUtil.getSystemUserName())) {
            AuthorityType authorityType;
            if (this.syncWhenMissingPeopleLogIn) {
                try {
                    this.synchronize(false, false, false);
                }
                catch (Exception e) {
                    logger.warn((Object)"User authenticated but failed to sync with user registry", (Throwable)e);
                }
                if (this.personService.personExists(userName)) {
                    return true;
                }
            }
            if (this.autoCreatePeopleOnLogin && this.personService.createMissingPeople() && (authorityType = AuthorityType.getAuthorityType((String)userName)) == AuthorityType.USER) {
                this.personService.getPerson(userName);
                return true;
            }
        }
        return false;
    }

    private void syncWithPlugin(final String zone, UserRegistry userRegistry, boolean forceUpdate, boolean allowDeletions, boolean splitTxns, final Set<String> visitedZoneIds, final Set<String> allZoneIds) {
        Date lastModified;
        final String zoneId = "AUTH.EXT." + zone;
        final Set<String> zoneSet = this.getZones(zoneId);
        long lastModifiedMillis = forceUpdate ? -1L : this.getMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, zoneId, splitTxns);
        Date date = lastModified = lastModifiedMillis == -1L ? null : new Date(lastModifiedMillis);
        if (logger.isInfoEnabled()) {
            if (lastModified == null) {
                logger.info((Object)("Retrieving all groups from user registry '" + zone + "'"));
            } else {
                logger.info((Object)("Retrieving groups changed since " + DateFormat.getDateTimeInstance().format(lastModified) + " from user registry '" + zone + "'"));
            }
        }
        BatchProcessor<NodeDescription> groupProcessor = new BatchProcessor<NodeDescription>(zone + " Group Analysis", this.transactionService.getRetryingTransactionHelper(), userRegistry.getGroups(lastModified), this.workerThreads, 20, this.applicationEventPublisher, logger, this.loggingInterval);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Analyzer
        implements BatchProcessor.BatchProcessWorker<NodeDescription> {
            private final Map<String, String> groupsToCreate = new TreeMap<String, String>();
            private final Map<String, Set<String>> personParentAssocsToCreate = this.newPersonMap();
            private final Map<String, Set<String>> personParentAssocsToDelete = this.newPersonMap();
            private final Map<String, Set<String>> groupParentAssocsToCreate = new TreeMap<String, Set<String>>();
            private final Map<String, Set<String>> groupParentAssocsToDelete = new TreeMap<String, Set<String>>();
            private List<String> personsProcessed = new LinkedList<String>();
            private Set<String> allZonePersons;
            private Set<String> deletionCandidates;
            private long latestTime;

            public Analyzer(long latestTime) {
                this.latestTime = latestTime;
            }

            public long getLatestTime() {
                return this.latestTime;
            }

            public Set<String> getDeletionCandidates() {
                return this.deletionCandidates;
            }

            @Override
            public String getIdentifier(NodeDescription entry) {
                return entry.getSourceId();
            }

            @Override
            public void beforeProcess() throws Throwable {
                ChainingUserRegistrySynchronizer.this.ruleService.disableRules();
                AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
            }

            @Override
            public void afterProcess() throws Throwable {
                ChainingUserRegistrySynchronizer.this.ruleService.enableRules();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeDescription group) throws Throwable {
                PropertyMap groupProperties = group.getProperties();
                String groupName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_NAME);
                String groupShortName = ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName);
                Set<String> groupZones = ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(groupName);
                if (groupZones == null) {
                    this.updateGroup(group, false);
                } else {
                    TreeSet<String> intersection = new TreeSet<String>(groupZones);
                    intersection.retainAll(allZoneIds);
                    if (intersection.isEmpty()) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Updating group '" + groupShortName + "'. This group will in future be assumed to originate from user registry '" + zone + "'."));
                        }
                        ChainingUserRegistrySynchronizer.this.authorityService.removeAuthorityFromZones(groupName, groupZones);
                        ChainingUserRegistrySynchronizer.this.authorityService.addAuthorityToZones(groupName, zoneSet);
                    }
                    if (groupZones.contains(zoneId) || intersection.isEmpty()) {
                        this.updateGroup(group, true);
                    } else {
                        intersection.retainAll(visitedZoneIds);
                        if (!intersection.isEmpty()) {
                            return;
                        }
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Recreating occluded group '" + groupShortName + "'. This group was previously created through synchronization with a lower priority user registry."));
                        }
                        ChainingUserRegistrySynchronizer.this.authorityService.deleteAuthority(groupName);
                        this.updateGroup(group, false);
                    }
                }
                Analyzer analyzer = this;
                synchronized (analyzer) {
                    Date groupLastModified = group.getLastModified();
                    if (groupLastModified != null) {
                        this.latestTime = Math.max(this.latestTime, groupLastModified.getTime());
                    }
                }
            }

            private synchronized void updateGroup(NodeDescription group, boolean existed) {
                PropertyMap groupProperties = group.getProperties();
                String groupName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_NAME);
                String groupDisplayName = (String)groupProperties.get(ContentModel.PROP_AUTHORITY_DISPLAY_NAME);
                if (groupDisplayName == null) {
                    groupDisplayName = ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName);
                }
                this.recordParentAssociation(this.groupParentAssocsToCreate, groupName, null);
                Set<String> newChildPersons = this.newPersonSet();
                TreeSet<String> newChildGroups = new TreeSet<String>();
                for (String child : group.getChildAssociations()) {
                    if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) {
                        newChildPersons.add(child);
                        continue;
                    }
                    newChildGroups.add(child);
                }
                if (existed) {
                    ChainingUserRegistrySynchronizer.this.authorityService.setAuthorityDisplayName(groupName, groupDisplayName);
                    for (String child : ChainingUserRegistrySynchronizer.this.authorityService.getContainedAuthorities(null, groupName, true)) {
                        if (AuthorityType.getAuthorityType((String)child) == AuthorityType.USER) {
                            if (newChildPersons.remove(child)) continue;
                            this.recordParentAssociation(this.personParentAssocsToCreate, child, null);
                            this.recordParentAssociation(this.personParentAssocsToDelete, child, groupName);
                            continue;
                        }
                        if (newChildGroups.remove(child)) continue;
                        this.recordParentAssociation(this.groupParentAssocsToCreate, child, null);
                        this.recordParentAssociation(this.groupParentAssocsToDelete, child, groupName);
                    }
                } else {
                    this.groupsToCreate.put(groupName, groupDisplayName);
                }
                for (String child : newChildPersons) {
                    this.recordParentAssociation(this.personParentAssocsToCreate, child, groupName);
                }
                for (String child : newChildGroups) {
                    this.recordParentAssociation(this.groupParentAssocsToCreate, child, groupName);
                }
            }

            private void recordParentAssociation(Map<String, Set<String>> parentAssocs, String child, String parent) {
                Set<String> parents = parentAssocs.get(child);
                if (parents == null) {
                    parents = new TreeSet<String>();
                    parentAssocs.put(child, parents);
                }
                if (parent != null) {
                    parents.add(parent);
                }
            }

            private Set<String> newPersonSet() {
                return ChainingUserRegistrySynchronizer.this.personService.getUserNamesAreCaseSensitive() ? new TreeSet<String>() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
            }

            private Map<String, Set<String>> newPersonMap() {
                return ChainingUserRegistrySynchronizer.this.personService.getUserNamesAreCaseSensitive() ? new TreeMap<String, Set<String>>() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }

            private void logRetainParentAssociations(Map<String, Set<String>> parentAssocs, Set<String> toRetain) {
                Iterator<Map.Entry<String, Set<String>>> i = parentAssocs.entrySet().iterator();
                StringBuilder groupList = null;
                while (i.hasNext()) {
                    Map.Entry<String, Set<String>> entry = i.next();
                    String child = entry.getKey();
                    if (toRetain.contains(child)) continue;
                    if (logger.isDebugEnabled()) {
                        if (groupList == null) {
                            groupList = new StringBuilder(1024);
                        } else {
                            groupList.setLength(0);
                        }
                        for (String parent : entry.getValue()) {
                            if (groupList.length() > 0) {
                                groupList.append(", ");
                            }
                            groupList.append('\'').append(ChainingUserRegistrySynchronizer.this.authorityService.getShortName(parent)).append('\'');
                        }
                        logger.debug((Object)("Ignoring non-existent member '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(child) + "' in groups {" + groupList.toString() + "}"));
                    }
                    i.remove();
                }
            }

            public void processGroups(UserRegistry userRegistry, boolean allowDeletions, boolean splitTxns) {
                if (allowDeletions || !this.groupParentAssocsToCreate.isEmpty()) {
                    final Set<String> allZonePersons = this.newPersonSet();
                    final TreeSet<String> allZoneGroups = new TreeSet<String>();
                    ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            allZonePersons.addAll(ChainingUserRegistrySynchronizer.this.authorityService.getAllAuthoritiesInZone(zoneId, AuthorityType.USER));
                            allZoneGroups.addAll(ChainingUserRegistrySynchronizer.this.authorityService.getAllAuthoritiesInZone(zoneId, AuthorityType.GROUP));
                            return null;
                        }
                    }, true, splitTxns);
                    Set<String> personDeletionCandidates = this.newPersonSet();
                    personDeletionCandidates.addAll(allZonePersons);
                    TreeSet<String> groupDeletionCandidates = new TreeSet<String>();
                    groupDeletionCandidates.addAll(allZoneGroups);
                    allZoneGroups.addAll(this.groupsToCreate.keySet());
                    if (allowDeletions) {
                        for (String person : userRegistry.getPersonNames()) {
                            personDeletionCandidates.remove(person);
                        }
                        for (String group : userRegistry.getGroupNames()) {
                            groupDeletionCandidates.remove(group);
                        }
                        this.deletionCandidates = new TreeSet<String>();
                        this.deletionCandidates.addAll(personDeletionCandidates);
                        this.deletionCandidates.addAll(groupDeletionCandidates);
                        allZonePersons.removeAll(personDeletionCandidates);
                        allZoneGroups.removeAll(groupDeletionCandidates);
                    }
                    this.logRetainParentAssociations(this.groupParentAssocsToCreate, allZoneGroups);
                    this.groupParentAssocsToDelete.keySet().retainAll(allZoneGroups);
                    this.allZonePersons = allZonePersons;
                    if (!this.groupParentAssocsToCreate.isEmpty()) {
                        LinkedHashMap sortedGroupAssociations = new LinkedHashMap(this.groupParentAssocsToCreate.size() * 2);
                        ArrayList<String> authorityPath = new ArrayList<String>(5);
                        for (String authority : this.groupParentAssocsToCreate.keySet()) {
                            authorityPath.add(authority);
                            ChainingUserRegistrySynchronizer.this.visitGroupAssociations(authorityPath, this.groupParentAssocsToCreate, sortedGroupAssociations);
                            authorityPath.clear();
                        }
                        BatchProcessor groupCreator = new BatchProcessor(zone + " Group Creation and Association", ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), sortedGroupAssociations.entrySet(), ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                        groupCreator.process(new BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>(){

                            @Override
                            public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                                return entry.getKey() + " " + entry.getValue();
                            }

                            @Override
                            public void beforeProcess() throws Throwable {
                                ChainingUserRegistrySynchronizer.this.ruleService.disableRules();
                                AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
                            }

                            @Override
                            public void afterProcess() throws Throwable {
                                ChainingUserRegistrySynchronizer.this.ruleService.enableRules();
                                AuthenticationUtil.clearCurrentSecurityContext();
                            }

                            @Override
                            public void process(Map.Entry<String, Set<String>> entry) throws Throwable {
                                String child = entry.getKey();
                                String groupDisplayName = (String)groupsToCreate.get(child);
                                if (groupDisplayName != null) {
                                    String groupShortName = ChainingUserRegistrySynchronizer.this.authorityService.getShortName(child);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Creating group '" + groupShortName + "'"));
                                    }
                                    ChainingUserRegistrySynchronizer.this.authorityService.createAuthority(AuthorityType.getAuthorityType((String)child), groupShortName, groupDisplayName, zoneSet);
                                }
                                this.maintainAssociations(child);
                            }
                        }, splitTxns);
                    }
                }
            }

            public void finalizeAssociations(UserRegistry userRegistry, boolean splitTxns) {
                this.personParentAssocsToCreate.keySet().removeAll(this.personsProcessed);
                this.logRetainParentAssociations(this.personParentAssocsToCreate, this.allZonePersons);
                if (!this.personParentAssocsToCreate.isEmpty()) {
                    BatchProcessor<Map.Entry<String, Set<String>>> groupCreator = new BatchProcessor<Map.Entry<String, Set<String>>>(zone + " Authority Association", ChainingUserRegistrySynchronizer.this.transactionService.getRetryingTransactionHelper(), this.personParentAssocsToCreate.entrySet(), ChainingUserRegistrySynchronizer.this.workerThreads, 20, ChainingUserRegistrySynchronizer.this.applicationEventPublisher, logger, ChainingUserRegistrySynchronizer.this.loggingInterval);
                    groupCreator.process(new BatchProcessor.BatchProcessWorker<Map.Entry<String, Set<String>>>(){

                        @Override
                        public String getIdentifier(Map.Entry<String, Set<String>> entry) {
                            return entry.getKey() + " " + entry.getValue();
                        }

                        @Override
                        public void beforeProcess() throws Throwable {
                            ChainingUserRegistrySynchronizer.this.ruleService.disableRules();
                            AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
                        }

                        @Override
                        public void afterProcess() throws Throwable {
                            ChainingUserRegistrySynchronizer.this.ruleService.enableRules();
                            AuthenticationUtil.clearCurrentSecurityContext();
                        }

                        @Override
                        public void process(Map.Entry<String, Set<String>> entry) throws Throwable {
                            this.maintainAssociations(entry.getKey());
                        }
                    }, splitTxns);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void maintainAssociations(String authorityName) throws BatchUpdateException {
                Set<String> parentsToDelete;
                Set<String> parents;
                boolean isPerson = AuthorityType.getAuthorityType((String)authorityName) == AuthorityType.USER;
                Set<String> set = parents = isPerson ? this.personParentAssocsToCreate.get(authorityName) : this.groupParentAssocsToCreate.get(authorityName);
                if (parents != null && !parents.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        for (String groupName : parents) {
                            logger.debug((Object)("Adding '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authorityName) + "' to group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(groupName) + "'"));
                        }
                    }
                    try {
                        ChainingUserRegistrySynchronizer.this.authorityService.addAuthority(parents, authorityName);
                    }
                    catch (UnknownAuthorityException e) {
                        BatchUpdateException e1 = new BatchUpdateException();
                        e1.initCause((Throwable)((Object)e));
                        throw e1;
                    }
                }
                Set<String> set2 = parentsToDelete = isPerson ? this.personParentAssocsToDelete.get(authorityName) : this.groupParentAssocsToDelete.get(authorityName);
                if (parentsToDelete != null && !parentsToDelete.isEmpty()) {
                    for (String parent : parentsToDelete) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Removing '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authorityName) + "' from group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(parent) + "'"));
                        }
                        ChainingUserRegistrySynchronizer.this.authorityService.removeAuthority(parent, authorityName);
                    }
                }
                if (isPerson) {
                    Analyzer analyzer = this;
                    synchronized (analyzer) {
                        this.personsProcessed.add(authorityName);
                    }
                }
            }
        }
        final Analyzer groupAnalyzer = new Analyzer(lastModifiedMillis);
        int groupProcessedCount = groupProcessor.process(groupAnalyzer, splitTxns);
        groupAnalyzer.processGroups(userRegistry, allowDeletions, splitTxns);
        lastModifiedMillis = forceUpdate ? -1L : this.getMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, zoneId, splitTxns);
        Date date2 = lastModified = lastModifiedMillis == -1L ? null : new Date(lastModifiedMillis);
        if (logger.isInfoEnabled()) {
            if (lastModified == null) {
                logger.info((Object)("Retrieving all users from user registry '" + zone + "'"));
            } else {
                logger.info((Object)("Retrieving users changed since " + DateFormat.getDateTimeInstance().format(lastModified) + " from user registry '" + zone + "'"));
            }
        }
        BatchProcessor<NodeDescription> personProcessor = new BatchProcessor<NodeDescription>(zone + " User Creation and Association", this.transactionService.getRetryingTransactionHelper(), userRegistry.getPersons(lastModified), this.workerThreads, 10, this.applicationEventPublisher, logger, this.loggingInterval);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PersonWorker
        implements BatchProcessor.BatchProcessWorker<NodeDescription> {
            private long latestTime;

            public PersonWorker(long latestTime) {
                this.latestTime = latestTime;
            }

            public long getLatestTime() {
                return this.latestTime;
            }

            @Override
            public String getIdentifier(NodeDescription entry) {
                return entry.getSourceId();
            }

            @Override
            public void beforeProcess() throws Throwable {
                ChainingUserRegistrySynchronizer.this.ruleService.disableRules();
                AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
            }

            @Override
            public void afterProcess() throws Throwable {
                ChainingUserRegistrySynchronizer.this.ruleService.enableRules();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(NodeDescription person) throws Throwable {
                HashMap<QName, Serializable> personProperties = new HashMap<QName, Serializable>(person.getProperties());
                String personName = (String)((Object)personProperties.get(ContentModel.PROP_USERNAME));
                Set<String> zones = ChainingUserRegistrySynchronizer.this.authorityService.getAuthorityZones(personName);
                if (zones == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating user '" + personName + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.personService.createPerson(personProperties, zoneSet);
                } else if (zones.contains(zoneId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Updating user '" + personName + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.personService.setPersonProperties(personName, personProperties, false);
                } else {
                    TreeSet<String> intersection = new TreeSet<String>(zones);
                    intersection.retainAll(allZoneIds);
                    if (intersection.size() == 0) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Updating user '" + personName + "'. This user will in future be assumed to originate from user registry '" + zone + "'."));
                        }
                        ChainingUserRegistrySynchronizer.this.authorityService.removeAuthorityFromZones(personName, zones);
                        ChainingUserRegistrySynchronizer.this.authorityService.addAuthorityToZones(personName, zoneSet);
                        ChainingUserRegistrySynchronizer.this.personService.setPersonProperties(personName, personProperties);
                    } else {
                        intersection.retainAll(visitedZoneIds);
                        if (intersection.size() > 0) {
                            return;
                        }
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Recreating occluded user '" + personName + "'. This user was previously created through synchronization with a lower priority user registry."));
                        }
                        ChainingUserRegistrySynchronizer.this.personService.deletePerson(personName);
                        ChainingUserRegistrySynchronizer.this.personService.createPerson(personProperties, zoneSet);
                    }
                }
                groupAnalyzer.maintainAssociations(personName);
                PersonWorker personWorker = this;
                synchronized (personWorker) {
                    Date personLastModified = person.getLastModified();
                    if (personLastModified != null) {
                        this.latestTime = Math.max(this.latestTime, personLastModified.getTime());
                    }
                }
            }
        }
        PersonWorker persons = new PersonWorker(lastModifiedMillis);
        int personProcessedCount = personProcessor.process(persons, splitTxns);
        groupAnalyzer.finalizeAssociations(userRegistry, splitTxns);
        long latestTime = groupAnalyzer.getLatestTime();
        if (latestTime != -1L) {
            this.setMostRecentUpdateTime(GROUP_LAST_MODIFIED_ATTRIBUTE, zoneId, latestTime, splitTxns);
        }
        if ((latestTime = persons.getLatestTime()) != -1L) {
            this.setMostRecentUpdateTime(PERSON_LAST_MODIFIED_ATTRIBUTE, zoneId, latestTime, splitTxns);
        }
        if (allowDeletions) {
            BatchProcessor<String> authorityDeletionProcessor = new BatchProcessor<String>(zone + " Authority Deletion", this.transactionService.getRetryingTransactionHelper(), groupAnalyzer.getDeletionCandidates(), this.workerThreads, 10, this.applicationEventPublisher, logger, this.loggingInterval);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class AuthorityDeleter
            implements BatchProcessor.BatchProcessWorker<String> {
                private int personProcessedCount;
                private int groupProcessedCount;

                AuthorityDeleter() {
                }

                public int getPersonProcessedCount() {
                    return this.personProcessedCount;
                }

                public int getGroupProcessedCount() {
                    return this.groupProcessedCount;
                }

                @Override
                public String getIdentifier(String entry) {
                    return entry;
                }

                @Override
                public void beforeProcess() throws Throwable {
                    ChainingUserRegistrySynchronizer.this.ruleService.disableRules();
                    AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
                }

                @Override
                public void afterProcess() throws Throwable {
                    ChainingUserRegistrySynchronizer.this.ruleService.enableRules();
                    AuthenticationUtil.clearCurrentSecurityContext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(String authority) throws Throwable {
                    if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.USER) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Deleting user '" + authority + "'"));
                        }
                        ChainingUserRegistrySynchronizer.this.personService.deletePerson(authority);
                        AuthorityDeleter authorityDeleter = this;
                        synchronized (authorityDeleter) {
                            ++this.personProcessedCount;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting group '" + ChainingUserRegistrySynchronizer.this.authorityService.getShortName(authority) + "'"));
                    }
                    ChainingUserRegistrySynchronizer.this.authorityService.deleteAuthority(authority);
                    AuthorityDeleter authorityDeleter = this;
                    synchronized (authorityDeleter) {
                        ++this.groupProcessedCount;
                    }
                }
            }
            AuthorityDeleter authorityDeleter = new AuthorityDeleter();
            authorityDeletionProcessor.process(authorityDeleter, splitTxns);
            groupProcessedCount += authorityDeleter.getGroupProcessedCount();
            personProcessedCount += authorityDeleter.getPersonProcessedCount();
        }
        visitedZoneIds.add(zoneId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Finished synchronizing users and groups with user registry '" + zone + "'"));
            logger.info((Object)(personProcessedCount + " user(s) and " + groupProcessedCount + " group(s) processed"));
        }
    }

    private void visitGroupAssociations(List<String> authorityPath, Map<String, Set<String>> associationsOld, Map<String, Set<String>> associationsNew) {
        String authorityName = authorityPath.get(authorityPath.size() - 1);
        if (!associationsNew.containsKey(authorityName)) {
            Set<String> associations = associationsOld.get(authorityName);
            if (!associations.isEmpty()) {
                int insertIndex = authorityPath.size();
                Iterator<String> i = associations.iterator();
                while (i.hasNext()) {
                    String parentAuthority = i.next();
                    if (authorityPath.contains(parentAuthority)) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Detected cyclic dependencies in group '" + this.authorityService.getShortName(parentAuthority) + "'"));
                        }
                        i.remove();
                        continue;
                    }
                    authorityPath.add(parentAuthority);
                    this.visitGroupAssociations(authorityPath, associationsOld, associationsNew);
                    authorityPath.remove(insertIndex);
                }
            }
            if (AuthorityType.getAuthorityType((String)authorityName) != AuthorityType.USER) {
                associationsNew.put(authorityName, associations);
            }
        }
    }

    private long getMostRecentUpdateTime(final String label, final String zoneId, boolean splitTxns) {
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                Long updateTime = (Long)ChainingUserRegistrySynchronizer.this.attributeService.getAttribute(new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, label, zoneId});
                return updateTime == null ? -1L : updateTime;
            }
        }, true, splitTxns);
    }

    private void setMostRecentUpdateTime(final String label, final String zoneId, final long lastModifiedMillis, boolean splitTxns) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizer.this.attributeService.setAttribute(Long.valueOf(lastModifiedMillis), new Serializable[]{ChainingUserRegistrySynchronizer.ROOT_ATTRIBUTE_PATH, label, zoneId});
                return null;
            }
        }, false, splitTxns);
    }

    private Set<String> getZones(String zoneId) {
        HashSet<String> zones = new HashSet<String>(5);
        zones.add("APP.DEFAULT");
        zones.add(zoneId);
        return zones;
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.syncOnStartup) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    try {
                        ChainingUserRegistrySynchronizer.this.synchronize(false, false, true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed initial synchronize with user registries", (Throwable)e);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

