/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class SiteAVMBootstrap
extends AbstractLifecycleBean {
    private String storeName;
    private String rootDir;
    private AVMService avmService;
    private PermissionService permissionService;
    private TransactionService transactionService;

    public void setRootdir(String rootdir) {
        if (this.rootDir != null && this.rootDir.length() == 0) {
            this.rootDir = null;
        }
        this.rootDir = rootdir;
    }

    public void setStorename(String storename) {
        this.storeName = storename;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                SiteAVMBootstrap.this.bootstrap();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void bootstrap() {
        PropertyCheck.mandatory((Object)((Object)this), (String)"avmService", (Object)this.avmService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"storeName", (Object)this.storeName);
        PropertyCheck.mandatory((Object)((Object)this), (String)"rootDir", (Object)this.rootDir);
        if (this.transactionService.isReadOnly()) {
            return;
        }
        if (this.avmService.getStore(this.storeName) == null) {
            this.avmService.createStore(this.storeName);
            this.avmService.setStoreProperty(this.storeName, QName.createQName(null, (String)".sitestore"), new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"true")));
            this.avmService.createDirectory(this.storeName + ":/", this.rootDir);
            StoreRef store = new StoreRef("avm", this.storeName);
            this.permissionService.setPermission(store, "GROUP_EVERYONE", "Read", true);
            this.permissionService.setPermission(store, AuthenticationUtil.getGuestUserName(), "Read", true);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

