/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.template.BaseTemplateProcessorExtension;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ValueDerivingMapFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class People
extends BaseTemplateProcessorExtension
implements InitializingBean {
    private ServiceRegistry services;
    private AuthorityDAO authorityDAO;
    private AuthorityService authorityService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private StoreRef storeRef;
    private ValueDerivingMapFactory<TemplateNode, String, Boolean> valueDerivingMapFactory;

    public void afterPropertiesSet() throws Exception {
        HashMap<String, ValueDerivingMapFactory.ValueDeriver<TemplateNode, Boolean>> capabilityTesters = new HashMap<String, ValueDerivingMapFactory.ValueDeriver<TemplateNode, Boolean>>(5);
        capabilityTesters.put("isAdmin", new ValueDerivingMapFactory.ValueDeriver<TemplateNode, Boolean>(){

            @Override
            public Boolean deriveValue(TemplateNode source) {
                return People.this.isAdmin(source);
            }
        });
        capabilityTesters.put("isGuest", new ValueDerivingMapFactory.ValueDeriver<TemplateNode, Boolean>(){

            @Override
            public Boolean deriveValue(TemplateNode source) {
                return People.this.isGuest(source);
            }
        });
        capabilityTesters.put("isMutable", new ValueDerivingMapFactory.ValueDeriver<TemplateNode, Boolean>(){

            @Override
            public Boolean deriveValue(TemplateNode source) {
                String sourceUser = (String)((Object)source.getProperties().get(ContentModel.PROP_USERNAME));
                if (!People.this.authenticationService.isAuthenticationMutable(sourceUser)) {
                    return false;
                }
                String currentUser = People.this.authenticationService.getCurrentUserName();
                if (currentUser.equals(sourceUser) || People.this.authorityService.isAdminAuthority(currentUser)) {
                    return true;
                }
                return false;
            }
        });
        this.valueDerivingMapFactory = new ValueDerivingMapFactory(capabilityTesters);
    }

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public TemplateNode getPerson(String username) {
        ParameterCheck.mandatoryString((String)"Username", (String)username);
        TemplateNode person = null;
        if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username);
            person = new TemplateNode(personRef, this.services, this.getTemplateImageResolver());
        }
        return person;
    }

    public TemplateNode getGroup(String groupName) {
        ParameterCheck.mandatoryString((String)"GroupName", (String)groupName);
        TemplateNode group = null;
        NodeRef groupRef = this.authorityDAO.getAuthorityNodeRefOrNull(groupName);
        if (groupRef != null) {
            group = new TemplateNode(groupRef, this.services, this.getTemplateImageResolver());
        }
        return group;
    }

    public List<TemplateNode> getMembers(TemplateNode group) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        return this.getContainedAuthorities(group, AuthorityType.USER, true);
    }

    public List<TemplateNode> getMembers(TemplateNode group, boolean recurse) {
        ParameterCheck.mandatory((String)"Group", (Object)group);
        return this.getContainedAuthorities(group, AuthorityType.USER, recurse);
    }

    public List<TemplateNode> getContainerGroups(TemplateNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        Set<String> authorities = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, (String)((Object)person.getProperties().get(ContentModel.PROP_USERNAME)), false);
        ArrayList<TemplateNode> parents = new ArrayList<TemplateNode>(authorities.size());
        for (String authority : authorities) {
            TemplateNode group = this.getGroup(authority);
            if (group == null) continue;
            parents.add(group);
        }
        return parents;
    }

    public boolean isAdmin(TemplateNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isAdminAuthority((String)((Object)person.getProperties().get(ContentModel.PROP_USERNAME)));
    }

    public boolean isGuest(TemplateNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.authorityService.isGuestAuthority((String)((Object)person.getProperties().get(ContentModel.PROP_USERNAME)));
    }

    public Map<String, Boolean> getCapabilities(TemplateNode person) {
        ParameterCheck.mandatory((String)"Person", (Object)person);
        return this.valueDerivingMapFactory.getMap(person);
    }

    public boolean isAccountEnabled(TemplateNode person) {
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser())) {
            return this.authenticationService.getAuthenticationEnabled((String)((Object)person.getProperties().get(ContentModel.PROP_USERNAME)));
        }
        return true;
    }

    private List<TemplateNode> getContainedAuthorities(TemplateNode container, AuthorityType type, boolean recurse) {
        List<TemplateNode> members = null;
        if (container.getType().equals((Object)ContentModel.TYPE_AUTHORITY_CONTAINER)) {
            String groupName = (String)((Object)container.getProperties().get(ContentModel.PROP_AUTHORITY_NAME));
            Set<String> authorities = this.authorityService.getContainedAuthorities(type, groupName, !recurse);
            members = new ArrayList<TemplateNode>(authorities.size());
            for (String authority : authorities) {
                TemplateNode person;
                AuthorityType authorityType = AuthorityType.getAuthorityType((String)authority);
                if (authorityType.equals((Object)AuthorityType.GROUP)) {
                    TemplateNode group = this.getGroup(authority);
                    if (group == null) continue;
                    members.add(group);
                    continue;
                }
                if (!authorityType.equals((Object)AuthorityType.USER) || (person = this.getPerson(authority)) == null) continue;
                members.add(person);
            }
        }
        return members != null ? members : Collections.emptyList();
    }
}

