/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.magick.ImageResizeOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.rendition.RenditionServiceImpl;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.repo.thumbnail.ThumbnailServiceImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ThumbnailServiceImplParameterTest {
    private ActionService mockActionService = (ActionService)Mockito.mock(ActionService.class);
    private RenditionServiceImpl renditionService;
    private ThumbnailService thumbnailService;
    private final NodeRef dummyNodeRef1 = new NodeRef("workspace", "dummy", "dummyID_1");
    private final NodeRef dummyNodeRef2 = new NodeRef("workspace", "dummy", "dummyID_2");
    private final NodeRef dummyNodeRef3 = new NodeRef("workspace", "dummy", "dummyID_3");

    @Before
    public void initMockObjects() {
        this.renditionService = new RenditionServiceImpl(){

            public RenditionDefinition loadRenditionDefinition(QName renditionDefinitionName) {
                return null;
            }
        };
        this.renditionService.setActionService(this.mockActionService);
        ThumbnailServiceImpl thumbs = new ThumbnailServiceImpl(){

            public NodeRef getThumbnailByName(NodeRef node, QName contentProperty, String thumbnailName) {
                return null;
            }

            public NodeRef getThumbnailNode(ChildAssociationRef thumbnailRef) {
                return null;
            }
        };
        thumbs.setRenditionService(this.renditionService);
        thumbs.setThumbnailRegistry(new ThumbnailRegistry(){

            public ThumbnailRenditionConvertor getThumbnailRenditionConvertor() {
                return new ThumbnailRenditionConvertor();
            }
        });
        thumbs.setNodeService((NodeService)Mockito.mock(NodeService.class));
        this.thumbnailService = thumbs;
    }

    @Test
    public void createThumbnailPassesParametersToActionService() {
        HashMap<String, Object> parametersUnderTest = new HashMap<String, Object>();
        parametersUnderTest.put("xsize", new Integer(42));
        parametersUnderTest.put("ysize", new Integer(93));
        parametersUnderTest.put("commandOptions", "foo");
        parametersUnderTest.put("maintainAspectRatio", Boolean.TRUE);
        parametersUnderTest.put("resizeToThumbnail", Boolean.FALSE);
        parametersUnderTest.put("targetContentProperty", ContentModel.PROP_CONTENT);
        parametersUnderTest.put("rendition-destination-node", this.dummyNodeRef2);
        ImageTransformationOptions imageTransOpts = new ImageTransformationOptions();
        imageTransOpts.setTargetNodeRef(this.dummyNodeRef2);
        imageTransOpts.setTargetContentProperty((QName)parametersUnderTest.get("targetContentProperty"));
        imageTransOpts.setCommandOptions((String)parametersUnderTest.get("commandOptions"));
        ImageResizeOptions resizeOptions = new ImageResizeOptions();
        resizeOptions.setHeight((Integer)parametersUnderTest.get("ysize"));
        resizeOptions.setWidth((Integer)parametersUnderTest.get("xsize"));
        resizeOptions.setMaintainAspectRatio((Boolean)parametersUnderTest.get("maintainAspectRatio"));
        resizeOptions.setResizeToThumbnail((Boolean)parametersUnderTest.get("resizeToThumbnail"));
        imageTransOpts.setResizeOptions(resizeOptions);
        ThumbnailParentAssociationDetails assocDetails = new ThumbnailParentAssociationDetails(this.dummyNodeRef3, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"homerSimpson"));
        this.thumbnailService.createThumbnail(this.dummyNodeRef1, ContentModel.PROP_CONTENT, "image/jpeg", imageTransOpts, "bartSimpson", assocDetails);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Action.class);
        ((ActionService)Mockito.verify((Object)this.mockActionService)).executeAction((Action)argument.capture(), (NodeRef)Matchers.any(NodeRef.class), Matchers.anyBoolean(), Matchers.anyBoolean());
        Action action = (Action)argument.getValue();
        RenditionDefinition renditionDefn = (RenditionDefinition)action;
        Map<String, Serializable> parameters = renditionDefn.getParameterValues();
        for (String s : parametersUnderTest.keySet()) {
            if (!parameters.keySet().contains(s) || parameters.get(s) == null || parameters.get(s).toString().length() == 0) {
                Assert.fail((String)("Missing parameter " + s));
            }
            Assert.assertEquals((String)("Parameter " + s + " had wrong value."), parametersUnderTest.get(s), (Object)parameters.get(s));
        }
    }
}

