/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateThumbnailActionExecuter
extends ActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(UpdateThumbnailActionExecuter.class);
    private RenditionService renditionService;
    private ThumbnailService thumbnailService;
    private NodeService nodeService;
    public static final String NAME = "update-thumbnail";
    public static final String PARAM_CONTENT_PROPERTY = "content-property";
    public static final String PARAM_THUMBNAIL_NODE = "thumbnail-node";

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        NodeRef thumbnailNodeRef = (NodeRef)action.getParameterValue(PARAM_THUMBNAIL_NODE);
        if (thumbnailNodeRef == null) {
            thumbnailNodeRef = actionedUponNodeRef;
        }
        if (this.nodeService.exists(thumbnailNodeRef) && this.renditionService.isRendition(thumbnailNodeRef)) {
            ChildAssociationRef parent = this.renditionService.getSourceNode(thumbnailNodeRef);
            String thumbnailName = parent.getQName().getLocalName();
            ThumbnailRegistry registry = this.thumbnailService.getThumbnailRegistry();
            ThumbnailDefinition details = registry.getThumbnailDefinition(thumbnailName);
            if (details == null) {
                throw new AlfrescoRuntimeException("The thumbnail name '" + thumbnailName + "' is not registered");
            }
            QName contentProperty = (QName)action.getParameterValue(PARAM_CONTENT_PROPERTY);
            if (contentProperty == null) {
                contentProperty = ContentModel.PROP_CONTENT;
            }
            this.thumbnailService.updateThumbnail(thumbnailNodeRef, details.getTransformationOptions());
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_CONTENT_PROPERTY, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_CONTENT_PROPERTY)));
        paramList.add(new ParameterDefinitionImpl(PARAM_THUMBNAIL_NODE, DataTypeDefinition.QNAME, false, this.getParamDisplayLabel(PARAM_THUMBNAIL_NODE)));
    }
}

