/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionAwareSingleton<T>
extends TransactionListenerAdapter {
    private final String txnKey = GUID.generate();
    private final ReentrantReadWriteLock.ReadLock singletonReadLock;
    private final ReentrantReadWriteLock.WriteLock singletonWriteLock;
    private Object singletonValue;

    public TransactionAwareSingleton() {
        ReentrantReadWriteLock serverReadWriteLock = new ReentrantReadWriteLock();
        this.singletonReadLock = serverReadWriteLock.readLock();
        this.singletonWriteLock = serverReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(Object value) {
        this.singletonWriteLock.lock();
        try {
            this.singletonValue = value;
            Object var3_2 = null;
            this.singletonWriteLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.singletonWriteLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue() {
        this.singletonReadLock.lock();
        try {
            Object object = this.singletonValue;
            Object var3_2 = null;
            this.singletonReadLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.singletonReadLock.unlock();
            throw throwable;
        }
    }

    public T get() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            return (T)storage.newValue;
        }
        return (T)this.getValue();
    }

    public void put(T value) {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage == null) {
            storage = new TransactionStorage();
            AlfrescoTransactionSupport.bindResource(this.txnKey, storage);
            AlfrescoTransactionSupport.bindListener(this);
        }
        storage.newValue = value;
    }

    @Override
    public void afterCommit() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            this.setValue(storage.newValue);
        }
    }

    private static class TransactionStorage {
        public Object newValue;

        private TransactionStorage() {
        }
    }
}

